/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;

public class SentMessages
implements ToXContent,
Iterable<SentMessage> {
    private String accountName;
    private List<SentMessage> messages;

    public SentMessages(String accountName, List<SentMessage> messages) {
        this.accountName = accountName;
        this.messages = messages;
    }

    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public Iterator<SentMessage> iterator() {
        return this.messages.iterator();
    }

    public int count() {
        return this.messages.size();
    }

    public List<SentMessage> asList() {
        return Collections.unmodifiableList(this.messages);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.ACCOUNT, this.accountName);
        builder.startArray(Field.SENT_MESSAGES);
        for (SentMessage message : this.messages) {
            message.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    static interface Field {
        public static final String ACCOUNT = new String("account");
        public static final String SENT_MESSAGES = new String("sent_messages");
        public static final String STATUS = new String("status");
        public static final String REASON = new String("reason");
        public static final String REQUEST = new String("request");
        public static final String RESPONSE = new String("response");
        public static final String MESSAGE = new String("message");
    }

    public static class SentMessage
    implements ToXContent {
        final String targetName;
        final TargetType targetType;
        final HipChatMessage message;
        @Nullable
        final HttpRequest request;
        @Nullable
        final HttpResponse response;
        @Nullable
        final String failureReason;

        public static SentMessage responded(String targetName, TargetType targetType, HipChatMessage message, HttpRequest request, HttpResponse response) {
            String failureReason = SentMessage.resolveFailureReason(response);
            return new SentMessage(targetName, targetType, message, request, response, failureReason);
        }

        public static SentMessage error(String targetName, TargetType targetType, HipChatMessage message, String reason) {
            return new SentMessage(targetName, targetType, message, null, null, reason);
        }

        private SentMessage(String targetName, TargetType targetType, HipChatMessage message, HttpRequest request, HttpResponse response, String failureReason) {
            this.targetName = targetName;
            this.targetType = targetType;
            this.message = message;
            this.request = request;
            this.response = response;
            this.failureReason = failureReason;
        }

        public boolean successful() {
            return this.failureReason == null;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.failureReason != null) {
                builder.field(Field.STATUS, "failure");
                builder.field(Field.REASON, this.failureReason);
                if (this.request != null) {
                    builder.field(Field.REQUEST);
                    this.request.toXContent(builder, params);
                }
                if (this.response != null) {
                    builder.field(Field.RESPONSE);
                    this.response.toXContent(builder, params);
                }
            } else {
                builder.field(Field.STATUS, "success");
            }
            builder.field(this.targetType.fieldName, this.targetName);
            builder.field(Field.MESSAGE);
            this.message.toXContent(builder, params, false);
            return builder.endObject();
        }

        private static String resolveFailureReason(HttpResponse response) {
            int status = response.status();
            if (status < 300) {
                return null;
            }
            switch (status) {
                case 400: {
                    return "Bad Request";
                }
                case 401: {
                    return "Unauthorized. The provided authentication token is invalid.";
                }
                case 403: {
                    return "Forbidden. The account doesn't have permission to send this message.";
                }
                case 404: 
                case 405: 
                case 406: {
                    return "The account used invalid HipChat APIs";
                }
                case 500: 
                case 503: {
                    return "HipChat Server Error.";
                }
            }
            return "Unknown Error";
        }

        public static enum TargetType {
            ROOM,
            USER;

            final String fieldName = new String(this.name().toLowerCase(Locale.ROOT));
        }
    }
}

