/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ExportException
extends ElasticsearchException
implements Iterable<ExportException> {
    private final List<ExportException> exceptions = new ArrayList<ExportException>();

    public ExportException(Throwable throwable) {
        super(throwable);
    }

    public ExportException(String msg, Object ... args) {
        super(msg, args);
    }

    public ExportException(String msg, Throwable throwable, Object ... args) {
        super(msg, throwable, args);
    }

    public ExportException(StreamInput in) throws IOException {
        super(in);
        for (int i = in.readVInt(); i > 0; --i) {
            this.exceptions.add(new ExportException(in));
        }
    }

    public boolean addExportException(ExportException e) {
        return this.exceptions.add(e);
    }

    public boolean hasExportExceptions() {
        return this.exceptions.size() > 0;
    }

    @Override
    public Iterator<ExportException> iterator() {
        return this.exceptions.iterator();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.exceptions.size());
        for (ExportException e : this.exceptions) {
            e.writeTo(out);
        }
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerToXContent(builder, params);
        if (this.hasExportExceptions()) {
            builder.startArray("exceptions");
            for (ExportException exception : this.exceptions) {
                builder.startObject();
                exception.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }
}

