/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.node;

import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.security.InternalClient;

public class NodeStatsCollector
extends Collector {
    public static final String NAME = "node-stats-collector";
    private final Client client;

    public NodeStatsCollector(Settings settings, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState, InternalClient client) {
        super(settings, NAME, clusterService, monitoringSettings, licenseState);
        this.client = client;
    }

    @Override
    protected Collection<MonitoringDoc> doCollect() throws Exception {
        NodesStatsRequest request = new NodesStatsRequest(new String[]{"_local"});
        request.indices(CommonStatsFlags.ALL);
        request.os(true);
        request.jvm(true);
        request.process(true);
        request.threadPool(true);
        request.fs(true);
        NodesStatsResponse response = (NodesStatsResponse)this.client.admin().cluster().nodesStats(request).actionGet();
        if (response.hasFailures()) {
            throw (FailedNodeException)response.failures().get(0);
        }
        NodeStats nodeStats = (NodeStats)response.getNodes().get(0);
        DiscoveryNode sourceNode = this.localNode();
        NodeStatsMonitoringDoc nodeStatsDoc = new NodeStatsMonitoringDoc(NodeStatsCollector.monitoringId(), NodeStatsCollector.monitoringVersion());
        nodeStatsDoc.setClusterUUID(this.clusterUUID());
        nodeStatsDoc.setTimestamp(System.currentTimeMillis());
        nodeStatsDoc.setSourceNode(sourceNode);
        nodeStatsDoc.setNodeId(sourceNode.getId());
        nodeStatsDoc.setNodeMaster(this.isLocalNodeMaster());
        nodeStatsDoc.setNodeStats(nodeStats);
        nodeStatsDoc.setMlockall(BootstrapInfo.isMemoryLocked());
        return Collections.singletonList(nodeStatsDoc);
    }
}

