/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.monitoring.AgentService;
import org.elasticsearch.xpack.monitoring.MonitoringFeatureSet;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.action.TransportMonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStateCollector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardsCollector;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalExporter;
import org.elasticsearch.xpack.monitoring.rest.action.RestMonitoringBulkAction;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.ssl.SSLService;

public class Monitoring
implements ActionPlugin {
    public static final String NAME = "monitoring";
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final boolean enabled;
    private final boolean transportClientMode;
    private final boolean tribeNode;

    public Monitoring(Settings settings, XPackLicenseState licenseState) {
        this.settings = settings;
        this.licenseState = licenseState;
        this.enabled = (Boolean)XPackSettings.MONITORING_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        this.tribeNode = XPackPlugin.isTribeNode(settings);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isTransportClient() {
        return this.transportClientMode;
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> {
            XPackPlugin.bindFeatureSet(b, MonitoringFeatureSet.class);
            if (this.transportClientMode || !this.enabled || this.tribeNode) {
                b.bind(Exporters.class).toProvider(Providers.of(null));
            }
        });
        return modules;
    }

    public Collection<Object> createComponents(InternalClient client, ThreadPool threadPool, ClusterService clusterService, LicenseService licenseService, SSLService sslService) {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        MonitoringSettings monitoringSettings = new MonitoringSettings(this.settings, clusterSettings);
        CleanerService cleanerService = new CleanerService(this.settings, clusterSettings, threadPool, this.licenseState);
        SSLService dynamicSSLService = sslService.createDynamicSSLService();
        HashMap<String, Exporter.Factory> exporterFactories = new HashMap<String, Exporter.Factory>();
        exporterFactories.put("http", config -> new HttpExporter(config, dynamicSSLService));
        exporterFactories.put("local", config -> new LocalExporter(config, client, clusterService, cleanerService));
        Exporters exporters = new Exporters(this.settings, exporterFactories, clusterService);
        HashSet<Collector> collectors = new HashSet<Collector>();
        collectors.add(new IndicesStatsCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client));
        collectors.add(new IndexStatsCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client));
        collectors.add(new ClusterStatsCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client, licenseService));
        collectors.add(new ClusterStateCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client));
        collectors.add(new ShardsCollector(this.settings, clusterService, monitoringSettings, this.licenseState));
        collectors.add(new NodeStatsCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client));
        collectors.add(new IndexRecoveryCollector(this.settings, clusterService, monitoringSettings, this.licenseState, client));
        AgentService agentService = new AgentService(this.settings, clusterSettings, collectors, exporters);
        return Arrays.asList(new Object[]{agentService, monitoringSettings, exporters, cleanerService});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ActionPlugin.ActionHandler((GenericAction)MonitoringBulkAction.INSTANCE, TransportMonitoringBulkAction.class, new Class[0]));
    }

    public List<Class<? extends RestHandler>> getRestHandlers() {
        if (!this.enabled || this.tribeNode) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RestMonitoringBulkAction.class);
    }
}

