/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsCollector;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class AgentService
extends AbstractLifecycleComponent {
    private volatile ExportingWorker exportingWorker;
    private volatile Thread workerThread;
    private volatile long samplingIntervalMillis;
    private final Collection<Collector> collectors;
    private final String[] settingsCollectors;
    private final Exporters exporters;

    public AgentService(Settings settings, ClusterSettings clusterSettings, Set<Collector> collectors, Exporters exporters) {
        super(settings);
        this.samplingIntervalMillis = ((TimeValue)MonitoringSettings.INTERVAL.get(settings)).millis();
        this.settingsCollectors = ((List)MonitoringSettings.COLLECTORS.get(settings)).toArray(new String[0]);
        this.collectors = Collections.unmodifiableSet(this.filterCollectors(collectors, this.settingsCollectors));
        this.exporters = exporters;
        clusterSettings.addSettingsUpdateConsumer(MonitoringSettings.INTERVAL, this::setInterval);
    }

    private void setInterval(TimeValue interval) {
        this.samplingIntervalMillis = interval.millis();
        this.applyIntervalSettings();
    }

    protected Set<Collector> filterCollectors(Set<Collector> collectors, String[] filters) {
        if (CollectionUtils.isEmpty((Object[])filters)) {
            return collectors;
        }
        HashSet<Collector> list = new HashSet<Collector>();
        for (Collector collector : collectors) {
            if (Regex.simpleMatch((String[])filters, (String)collector.name().toLowerCase(Locale.ROOT))) {
                list.add(collector);
                continue;
            }
            if (!(collector instanceof ClusterStatsCollector)) continue;
            list.add(collector);
        }
        return list;
    }

    protected void applyIntervalSettings() {
        if (this.samplingIntervalMillis <= 0L) {
            this.logger.info("data sampling is disabled due to interval settings [{}]", (Object)this.samplingIntervalMillis);
            if (this.workerThread != null) {
                this.exportingWorker.closed = true;
                this.exportingWorker = null;
                this.workerThread = null;
            }
        } else if (this.workerThread == null || !this.workerThread.isAlive()) {
            this.exportingWorker = new ExportingWorker();
            this.workerThread = new Thread((Runnable)this.exportingWorker, EsExecutors.threadName((Settings)this.settings, (String)"monitoring.exporters"));
            this.workerThread.setDaemon(true);
            this.workerThread.start();
        }
    }

    public void stopCollection() {
        ExportingWorker worker = this.exportingWorker;
        if (worker != null) {
            worker.stopCollecting();
        }
    }

    public void startCollection() {
        ExportingWorker worker = this.exportingWorker;
        if (worker != null) {
            worker.collecting = true;
        }
    }

    protected void doStart() {
        this.logger.debug("monitoring service started");
        this.exporters.start();
        this.applyIntervalSettings();
    }

    protected void doStop() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.exportingWorker.closed = true;
            this.workerThread.interrupt();
            try {
                this.workerThread.join(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.exporters.stop();
    }

    protected void doClose() {
        for (Exporter exporter : this.exporters) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to close exporter [{}]", (Object)exporter.name()), (Throwable)e);
            }
        }
    }

    public TimeValue getSamplingInterval() {
        return TimeValue.timeValueMillis((long)this.samplingIntervalMillis);
    }

    public String[] collectors() {
        return this.settingsCollectors;
    }

    class ExportingWorker
    implements Runnable {
        volatile boolean closed = false;
        volatile boolean collecting = true;
        final ReleasableLock collectionLock = new ReleasableLock((Lock)new ReentrantLock(false));

        ExportingWorker() {
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    Thread.sleep(AgentService.this.samplingIntervalMillis);
                    if (this.closed) continue;
                    ReleasableLock ignore = this.collectionLock.acquire();
                    Throwable throwable = null;
                    try {
                        Collection<MonitoringDoc> docs = this.collect();
                        if (docs.isEmpty() || this.closed) continue;
                        AgentService.this.exporters.export(docs);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignore == null) continue;
                        if (throwable != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignore.close();
                    }
                }
                catch (ExportException e) {
                    AgentService.this.logger.error("exception when exporting documents", (Throwable)((Object)e));
                }
                catch (InterruptedException e) {
                    AgentService.this.logger.trace("interrupted");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    AgentService.this.logger.error("background thread had an uncaught exception", (Throwable)e);
                }
            }
            AgentService.this.logger.debug("worker shutdown");
        }

        public void stopCollecting() {
            this.collecting = false;
            this.collectionLock.acquire().close();
        }

        private Collection<MonitoringDoc> collect() {
            if (AgentService.this.logger.isTraceEnabled()) {
                AgentService.this.logger.trace("collecting data - collectors [{}]", (Object)Strings.collectionToCommaDelimitedString((Iterable)AgentService.this.collectors));
            }
            ArrayList<MonitoringDoc> docs = new ArrayList<MonitoringDoc>();
            for (Collector collector : AgentService.this.collectors) {
                if (this.collecting) {
                    Collection<MonitoringDoc> result = collector.collect();
                    if (result != null) {
                        AgentService.this.logger.trace("adding [{}] collected docs from [{}] collector", (Object)result.size(), (Object)collector.name());
                        docs.addAll(result);
                    } else {
                        AgentService.this.logger.trace("skipping collected docs from [{}] collector", (Object)collector.name());
                    }
                }
                if (!this.closed) continue;
                break;
            }
            return docs;
        }
    }
}

