/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.extensions;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Map;
import org.elasticsearch.common.SuppressForbidden;

final class XPackExtensionPolicy
extends Policy {
    static final Permission SET_POLICY_PERMISSION = new SecurityPermission("setPolicy");
    static final Permission GET_POLICY_PERMISSION = new SecurityPermission("getPolicy");
    static final Permission CREATE_POLICY_PERMISSION = new SecurityPermission("createPolicy.JavaPolicy");
    final Policy basePolicy;
    final Map<String, Policy> extensions;
    final URL xpackURL;

    public XPackExtensionPolicy(Policy basePolicy, Map<String, Policy> extensions) {
        this.basePolicy = basePolicy;
        this.extensions = extensions;
        this.xpackURL = XPackExtensionPolicy.class.getProtectionDomain().getCodeSource().getLocation();
    }

    private boolean isPolicyPermission(Permission permission) {
        return GET_POLICY_PERMISSION.equals(permission) || CREATE_POLICY_PERMISSION.equals(permission) || SET_POLICY_PERMISSION.equals(permission);
    }

    @Override
    @SuppressForbidden(reason="fast equals check is desired")
    public boolean implies(ProtectionDomain domain, Permission permission) {
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null) {
            if (codeSource.getLocation().equals(this.xpackURL) && this.isPolicyPermission(permission)) {
                return false;
            }
            Policy extension = this.extensions.get(codeSource.getLocation().getFile());
            if (extension != null && extension.implies(domain, permission)) {
                return true;
            }
        }
        return this.basePolicy.implies(domain, permission);
    }
}

