/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.Watcher;

public class TextTemplateEngine
extends AbstractComponent {
    private final ScriptService service;

    public TextTemplateEngine(Settings settings, ScriptService service) {
        super(settings);
        this.service = service;
    }

    public String render(TextTemplate textTemplate, Map<String, Object> model) {
        Script script;
        CompiledScript compiledScript;
        ExecutableScript executable;
        Object result;
        if (textTemplate == null) {
            return null;
        }
        String template = textTemplate.getTemplate();
        XContentType contentType = this.detectContentType(template);
        Map<String, String> compileParams = this.compileParams(contentType);
        template = this.trimContentType(textTemplate);
        HashMap<String, Object> mergedModel = new HashMap<String, Object>();
        if (textTemplate.getParams() != null) {
            mergedModel.putAll(textTemplate.getParams());
        }
        mergedModel.putAll(model);
        HashMap<String, String> options = new HashMap<String, String>();
        if (textTemplate.getContentType() != null) {
            options.put("content_type", textTemplate.getContentType().mediaType());
        }
        if ((result = (executable = this.service.executable(compiledScript = this.service.compile(script = new Script(textTemplate.getType(), "mustache", template, options, mergedModel), Watcher.SCRIPT_CONTEXT, compileParams), model)).run()) instanceof BytesReference) {
            return ((BytesReference)result).utf8ToString();
        }
        return result.toString();
    }

    private String trimContentType(TextTemplate textTemplate) {
        String template = textTemplate.getTemplate();
        if (!template.startsWith("__")) {
            return template;
        }
        int index = template.indexOf("__::", 3);
        if (index >= 0 && index < 12) {
            template = template.length() == 6 ? "" : template.substring(index + 4);
        }
        return template;
    }

    private XContentType detectContentType(String content) {
        int endOfContentName;
        if (content.startsWith("__") && (endOfContentName = content.indexOf("__::", 3)) != -1) {
            return XContentType.fromMediaTypeOrFormat((String)content.substring(2, endOfContentName));
        }
        return null;
    }

    private Map<String, String> compileParams(XContentType contentType) {
        if (contentType == XContentType.JSON) {
            return Collections.singletonMap("content_type", "application/json");
        }
        return Collections.singletonMap("content_type", "text/plain");
    }
}

