/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;

public final class IteratingActionListener<T, U>
implements ActionListener<T>,
Runnable {
    private final List<U> consumables;
    private final ActionListener<T> delegate;
    private final BiConsumer<U, ActionListener<T>> consumer;
    private int position = 0;

    public IteratingActionListener(ActionListener<T> delegate, BiConsumer<U, ActionListener<T>> consumer, List<U> consumables) {
        this.delegate = delegate;
        this.consumer = consumer;
        this.consumables = Collections.unmodifiableList(consumables);
    }

    @Override
    public void run() {
        if (this.consumables.isEmpty()) {
            this.onResponse(null);
        } else if (this.position < 0 || this.position >= this.consumables.size()) {
            this.onFailure(new IllegalStateException("invalid position [" + this.position + "]. List size [" + this.consumables.size() + "]"));
        } else {
            this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
        }
    }

    public void onResponse(T response) {
        if (response == null) {
            if (this.position == this.consumables.size()) {
                this.delegate.onResponse(null);
            } else {
                this.consumer.accept((IteratingActionListener)this.consumables.get(this.position++), this);
            }
        } else {
            this.delegate.onResponse(response);
        }
    }

    public void onFailure(Exception e) {
        this.delegate.onFailure(e);
    }
}

