/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.action;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.action.XPackUsageRequest;
import org.elasticsearch.xpack.action.XPackUsageResponse;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final Set<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackUsageAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Set<XPackFeatureSet> featureSets) {
        super(settings, "cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, XPackUsageRequest::new);
        this.featureSets = featureSets;
    }

    protected String executor() {
        return "management";
    }

    protected XPackUsageResponse newResponse() {
        return new XPackUsageResponse();
    }

    protected void masterOperation(XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) throws Exception {
        List<XPackFeatureSet.Usage> usages = this.featureSets.stream().map(XPackFeatureSet::usage).collect(Collectors.toList());
        listener.onResponse((Object)new XPackUsageResponse(usages));
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

