/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.core.internal.net.NetUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NettyAllocator;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty4.ESLoggingHandler;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4TcpServerChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4Transport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(Netty4Transport.class);
    public static final Setting<Integer> WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.allocatedProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int workerCount;
    private final ByteSizeValue receivePredictorMin;
    private final ByteSizeValue receivePredictorMax;
    private final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    private volatile Bootstrap clientBootstrap;
    private volatile NioEventLoopGroup eventLoopGroup;
    static final AttributeKey<Netty4TcpChannel> CHANNEL_KEY = AttributeKey.newInstance((String)"es-channel");
    static final AttributeKey<Netty4TcpServerChannel> SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-server-channel");

    public Netty4Transport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors((Integer)EsExecutors.NODE_PROCESSORS_SETTING.get(settings));
        this.workerCount = (Integer)WORKER_COUNT.get(settings);
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            ThreadFactory threadFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_worker");
            this.eventLoopGroup = new NioEventLoopGroup(this.workerCount, threadFactory);
            this.clientBootstrap = this.createClientBootstrap(this.eventLoopGroup);
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings, this.eventLoopGroup);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createClientBootstrap(NioEventLoopGroup eventLoopGroup) {
        ByteSizeValue tcpReceiveBufferSize;
        ByteSizeValue tcpSendBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)eventLoopGroup);
        bootstrap.channel(NettyAllocator.getChannelType());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)((Boolean)TransportSettings.TCP_NO_DELAY.get(this.settings)));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)));
        if (((Boolean)TransportSettings.TCP_KEEP_ALIVE.get(this.settings)).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
            SocketOption keepCountOption;
            SocketOption keepIntervalOption;
            SocketOption keepIdleOption;
            if ((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepIdleOption), (Object)((Integer)TransportSettings.TCP_KEEP_IDLE.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)((Integer)TransportSettings.TCP_KEEP_INTERVAL.get(this.settings)));
            }
            if ((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                bootstrap.option(NioChannelOption.of((SocketOption)keepCountOption), (Object)((Integer)TransportSettings.TCP_KEEP_COUNT.get(this.settings)));
            }
        }
        if ((tcpSendBufferSize = (ByteSizeValue)TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TransportSettings.TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings, NioEventLoopGroup eventLoopGroup) {
        String name = profileSettings.profileName;
        if (logger.isDebugEnabled()) {
            logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], receive_predictor[{}->{}]", (Object)name, (Object)this.workerCount, (Object)profileSettings.portOrRange, (Object)profileSettings.bindHosts, (Object)profileSettings.publishHosts, (Object)this.receivePredictorMin, (Object)this.receivePredictorMax);
        }
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group((EventLoopGroup)eventLoopGroup);
        serverBootstrap.channel(NettyAllocator.getServerChannelType());
        serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler());
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)profileSettings.tcpKeepAlive);
        if (profileSettings.tcpKeepAlive && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
            SocketOption keepCountOption;
            SocketOption keepIntervalOption;
            SocketOption keepIdleOption;
            if (profileSettings.tcpKeepIdle >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIdleOption), (Object)profileSettings.tcpKeepIdle);
            }
            if (profileSettings.tcpKeepInterval >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)profileSettings.tcpKeepInterval);
            }
            if (profileSettings.tcpKeepCount >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepCountOption), (Object)profileSettings.tcpKeepCount);
            }
        }
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new ClientChannelInitializer();
    }

    protected Netty4TcpChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        Bootstrap bootstrapWithHandler = this.clientBootstrap.clone();
        bootstrapWithHandler.handler(this.getClientChannelInitializer(node));
        bootstrapWithHandler.remoteAddress((SocketAddress)address);
        ChannelFuture connectFuture = bootstrapWithHandler.connect();
        Channel channel = connectFuture.channel();
        if (channel == null) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)connectFuture.cause());
            throw new IOException(connectFuture.cause());
        }
        this.addClosedExceptionLogger(channel);
        Netty4TcpChannel nettyChannel = new Netty4TcpChannel(channel, false, "default", connectFuture);
        channel.attr(CHANNEL_KEY).set((Object)nettyChannel);
        return nettyChannel;
    }

    protected Netty4TcpServerChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
        Netty4TcpServerChannel esChannel = new Netty4TcpServerChannel(channel);
        channel.attr(SERVER_CHANNEL_KEY).set((Object)esChannel);
        return esChannel;
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasable[] releasableArray = new Releasable[3];
        releasableArray[0] = () -> {
            if (this.eventLoopGroup != null) {
                Future shutdownFuture = this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
                shutdownFuture.awaitUninterruptibly();
                if (!shutdownFuture.isSuccess()) {
                    logger.warn("Error closing netty event loop group", shutdownFuture.cause());
                }
            }
        };
        releasableArray[1] = this.serverBootstraps::clear;
        releasableArray[2] = () -> {
            this.clientBootstrap = null;
        };
        Releasables.close((Releasable[])releasableArray);
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener(f -> {
            if (!f.isSuccess()) {
                logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        });
    }

    @ChannelHandler.Sharable
    private class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private ServerChannelExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4TcpServerChannel serverChannel = (Netty4TcpServerChannel)ctx.channel().attr(SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4Transport.this.onServerException(serverChannel, new Exception(cause));
            } else {
                Netty4Transport.this.onServerException(serverChannel, (Exception)cause);
            }
        }
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            Netty4TcpChannel nettyTcpChannel = new Netty4TcpChannel(ch, true, this.name, ch.newSucceededFuture());
            ch.attr(CHANNEL_KEY).set((Object)nettyTcpChannel);
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this.pageCacheRecycler, Netty4Transport.this));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

