/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.TransportStatus;
import org.elasticsearch.transport.netty4.ByteBufStreamInput;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class ESLoggingHandler
extends LoggingHandler {
    private static final int MESSAGE_LENGTH_OFFSET = 2;
    private static final int REQUEST_ID_OFFSET = 6;
    private static final int STATUS_OFFSET = 14;
    private static final int VERSION_ID_OFFSET = 15;
    private static final int ACTION_OFFSET = 19;

    ESLoggingHandler() {
        super(LogLevel.TRACE);
    }

    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            try {
                return this.format(ctx, eventName, (ByteBuf)arg);
            }
            catch (Exception e) {
                this.logger.trace("an exception occurred formatting a trace message", (Throwable)e);
                return super.format(ctx, eventName, arg);
            }
        }
        return super.format(ctx, eventName, arg);
    }

    private String format(ChannelHandlerContext ctx, String eventName, ByteBuf arg) throws IOException {
        int readableBytes = arg.readableBytes();
        if (readableBytes == 0) {
            return super.format(ctx, eventName, (Object)arg);
        }
        if (readableBytes >= 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(ctx.channel().toString());
            int offset = arg.readerIndex();
            if (arg.getByte(offset) == 69 && arg.getByte(offset + 1) == 83) {
                if (readableBytes == 6) {
                    int length = arg.getInt(offset + 2);
                    if (length == -1) {
                        sb.append(" [ping]").append(' ').append(eventName).append(": ").append(readableBytes).append('B');
                        return sb.toString();
                    }
                } else if (readableBytes >= 19) {
                    int length = arg.getInt(offset + 2);
                    long requestId = arg.getLong(offset + 6);
                    byte status = arg.getByte(offset + 14);
                    boolean isRequest = TransportStatus.isRequest((byte)status);
                    String type = isRequest ? "request" : "response";
                    String version = Version.fromId((int)arg.getInt(offset + 15)).toString();
                    sb.append(" [length: ").append(length);
                    sb.append(", request id: ").append(requestId);
                    sb.append(", type: ").append(type);
                    sb.append(", version: ").append(version);
                    if (isRequest) {
                        int remaining = readableBytes - 19;
                        ByteBuf slice = arg.slice(offset + 19, remaining);
                        try (StreamInput in = this.in(status, slice, remaining);){
                            try (ThreadContext context = new ThreadContext(Settings.EMPTY);){
                                context.readHeaders(in);
                            }
                            sb.append(", action: ").append(in.readString());
                        }
                    }
                    sb.append(']');
                    sb.append(' ').append(eventName).append(": ").append(readableBytes).append('B');
                    return sb.toString();
                }
            }
        }
        return super.format(ctx, eventName, (Object)arg);
    }

    private StreamInput in(Byte status, ByteBuf slice, int remaining) throws IOException {
        ByteBufStreamInput in = new ByteBufStreamInput(slice, remaining);
        if (TransportStatus.isCompress((byte)status)) {
            Compressor compressor = CompressorFactory.compressor((BytesReference)Netty4Utils.toBytesReference(slice));
            return compressor.streamInput((StreamInput)in);
        }
        return in;
    }
}

