/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.transport;

import java.util.Locale;
import javax.net.ssl.SSLEngine;

public enum SSLClientAuth {
    NO{

        @Override
        public boolean enabled() {
            return false;
        }

        @Override
        public void configure(SSLEngine engine) {
            assert (!engine.getWantClientAuth());
            assert (!engine.getNeedClientAuth());
        }
    }
    ,
    OPTIONAL{

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLEngine engine) {
            engine.setWantClientAuth(true);
        }
    }
    ,
    REQUIRED{

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLEngine engine) {
            engine.setNeedClientAuth(true);
        }
    };


    public abstract boolean enabled();

    public abstract void configure(SSLEngine var1);

    public static SSLClientAuth parse(String value, SSLClientAuth defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        switch (value.toLowerCase(Locale.ROOT)) {
            case "no": 
            case "false": {
                return NO;
            }
            case "optional": {
                return OPTIONAL;
            }
            case "required": 
            case "true": {
                return REQUIRED;
            }
        }
        throw new IllegalArgumentException("could not resolve ssl client auth auth. unknown ssl client auth value [" + value + "]");
    }
}

