/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.shield.license.ShieldLicenseState;
import org.elasticsearch.shield.rest.RemoteHostHeader;
import org.elasticsearch.shield.transport.SSLClientAuth;
import org.elasticsearch.shield.transport.netty.ShieldNettyHttpServerTransport;
import org.jboss.netty.handler.ssl.SslHandler;

public class ShieldRestFilter
extends RestFilter {
    private final AuthenticationService service;
    private final ESLogger logger;
    private final ShieldLicenseState licenseState;
    private final boolean extractClientCertificate;

    @Inject
    public ShieldRestFilter(AuthenticationService service, RestController controller, Settings settings, ShieldLicenseState licenseState) {
        this.service = service;
        this.licenseState = licenseState;
        controller.registerFilter((RestFilter)this);
        boolean ssl = settings.getAsBoolean("shield.http.ssl", Boolean.valueOf(false));
        this.extractClientCertificate = ssl && SSLClientAuth.parse(settings.get("shield.http.ssl.client.auth"), ShieldNettyHttpServerTransport.HTTP_CLIENT_AUTH_DEFAULT).enabled();
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)settings, (String[])new String[0]);
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) throws Exception {
        if (this.licenseState.securityEnabled()) {
            if (request.method() != RestRequest.Method.OPTIONS) {
                if (this.extractClientCertificate) {
                    ShieldRestFilter.putClientCertificateInContext(request, this.logger);
                }
                this.service.authenticate(request);
            }
            RemoteHostHeader.process(request);
        }
        filterChain.continueProcessing(request, channel);
    }

    static void putClientCertificateInContext(RestRequest request, ESLogger logger) throws Exception {
        block6: {
            assert (request instanceof NettyHttpRequest);
            NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)request;
            SslHandler handler = (SslHandler)nettyHttpRequest.getChannel().getPipeline().get(SslHandler.class);
            assert (handler != null);
            try {
                Certificate[] certs = handler.getEngine().getSession().getPeerCertificates();
                if (certs instanceof X509Certificate[]) {
                    request.putInContext((Object)"__SHIELD_CLIENT_CERTIFICATE", (Object)certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("SSL Peer did not present a certificate on channel [{}]", (Throwable)e, new Object[]{nettyHttpRequest.getChannel()});
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("SSL Peer did not present a certificate on channel [{}]", new Object[]{nettyHttpRequest.getChannel()});
            }
        }
    }
}

