/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authz.accesscontrol;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;

public class IndicesAccessControl {
    public static final IndicesAccessControl ALLOW_ALL = new IndicesAccessControl(true, (ImmutableMap<String, IndexAccessControl>)ImmutableMap.of());
    private final boolean granted;
    private final ImmutableMap<String, IndexAccessControl> indexPermissions;

    public IndicesAccessControl(boolean granted, ImmutableMap<String, IndexAccessControl> indexPermissions) {
        this.granted = granted;
        this.indexPermissions = indexPermissions;
    }

    @Nullable
    public IndexAccessControl getIndexPermissions(String index) {
        return (IndexAccessControl)this.indexPermissions.get((Object)index);
    }

    public boolean isGranted() {
        return this.granted;
    }

    public static class IndexAccessControl {
        private final boolean granted;
        private final ImmutableSet<String> fields;
        private final ImmutableSet<BytesReference> queries;

        public IndexAccessControl(boolean granted, ImmutableSet<String> fields, ImmutableSet<BytesReference> queries) {
            this.granted = granted;
            this.fields = fields;
            this.queries = queries;
        }

        public boolean isGranted() {
            return this.granted;
        }

        @Nullable
        public ImmutableSet<String> getFields() {
            return this.fields;
        }

        @Nullable
        public ImmutableSet<BytesReference> getQueries() {
            return this.queries;
        }

        public IndexAccessControl merge(IndexAccessControl other) {
            if (!other.isGranted()) {
                return this;
            }
            boolean granted = this.granted;
            if (!granted) {
                assert (other.isGranted());
                return other;
            }
            ImmutableSet fields = null;
            if (this.fields != null && other.getFields() != null) {
                HashSet<String> _fields = new HashSet<String>();
                if (this.fields != null) {
                    _fields.addAll((Collection<String>)this.fields);
                }
                if (other.getFields() != null) {
                    _fields.addAll((Collection<String>)other.getFields());
                }
                fields = ImmutableSet.copyOf(_fields);
            }
            ImmutableSet queries = null;
            if (this.queries != null && other.getQueries() != null) {
                HashSet<BytesReference> _queries = new HashSet<BytesReference>();
                if (this.queries != null) {
                    _queries.addAll((Collection<BytesReference>)this.queries);
                }
                if (other.getQueries() != null) {
                    _queries.addAll((Collection<BytesReference>)other.getQueries());
                }
                queries = ImmutableSet.copyOf(_queries);
            }
            return new IndexAccessControl(granted, fields, queries);
        }
    }
}

