/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap.support;

import com.unboundid.ldap.sdk.SearchScope;
import java.util.Locale;

public enum LdapSearchScope {
    BASE(SearchScope.BASE),
    ONE_LEVEL(SearchScope.ONE),
    SUB_TREE(SearchScope.SUB);

    private final SearchScope scope;

    private LdapSearchScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope scope() {
        return this.scope;
    }

    public static LdapSearchScope resolve(String scope, LdapSearchScope defaultScope) {
        if (scope == null) {
            return defaultScope;
        }
        switch (scope.toLowerCase(Locale.ENGLISH)) {
            case "base": 
            case "object": {
                return BASE;
            }
            case "one_level": {
                return ONE_LEVEL;
            }
            case "sub_tree": {
                return SUB_TREE;
            }
        }
        throw new IllegalArgumentException("unknown search scope [" + scope + "]");
    }
}

