/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.ldap;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.authc.RealmConfig;
import org.elasticsearch.shield.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.shield.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.shield.authc.ldap.support.LdapSession;
import org.elasticsearch.shield.authc.ldap.support.LdapUtils;
import org.elasticsearch.shield.authc.ldap.support.SessionFactory;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.ssl.ClientSSLService;
import org.elasticsearch.shield.support.Exceptions;

public class LdapSessionFactory
extends SessionFactory {
    public static final String USER_DN_TEMPLATES_SETTING = "user_dn_templates";
    private final String[] userDnTemplates;
    private final LdapSession.GroupsResolver groupResolver;

    public LdapSessionFactory(RealmConfig config, ClientSSLService sslService) {
        super(config, sslService);
        Settings settings = config.settings();
        this.userDnTemplates = settings.getAsArray(USER_DN_TEMPLATES_SETTING);
        if (this.userDnTemplates == null) {
            throw new IllegalArgumentException("missing required LDAP setting [user_dn_templates]");
        }
        this.groupResolver = LdapSessionFactory.groupResolver(settings);
    }

    @Override
    protected LdapSession getSession(String username, SecuredString password) throws Exception {
        LDAPConnection connection;
        try {
            connection = this.serverSet.getConnection();
        }
        catch (LDAPException e) {
            throw new IOException("failed to connect to any LDAP servers", e);
        }
        LDAPException lastException = null;
        String passwordString = new String(password.internalChars());
        for (String template : this.userDnTemplates) {
            String dn = this.buildDnFromTemplate(username, template);
            try {
                connection.bind(dn, passwordString);
                return new LdapSession(this.connectionLogger, (LDAPInterface)connection, dn, this.groupResolver, this.timeout);
            }
            catch (LDAPException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("failed LDAP authentication with user template [{}] and DN [{}]", (Throwable)e, new Object[]{template, dn});
                } else {
                    this.logger.warn("failed LDAP authentication with user template [{}] and DN [{}]: {}", new Object[]{template, dn, e.getMessage()});
                }
                lastException = e;
            }
        }
        connection.close();
        throw Exceptions.authenticationError("failed LDAP authentication", lastException, new Object[0]);
    }

    String buildDnFromTemplate(String username, String template) {
        String escapedUsername = LdapUtils.escapedRDNValue(username);
        return new MessageFormat(template, Locale.ROOT).format(new Object[]{escapedUsername}, new StringBuffer(), (FieldPosition)null).toString();
    }

    static LdapSession.GroupsResolver groupResolver(Settings settings) {
        Settings searchSettings = settings.getAsSettings("group_search");
        if (!searchSettings.names().isEmpty()) {
            return new SearchGroupsResolver(searchSettings);
        }
        return new UserAttributeGroupsResolver(settings);
    }
}

