/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esusers.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.cli.CheckFileCommand;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.esusers.FileUserPasswdStore;
import org.elasticsearch.shield.authc.esusers.FileUserRolesStore;
import org.elasticsearch.shield.authc.support.Hasher;
import org.elasticsearch.shield.authc.support.SecuredString;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.support.NoOpLogger;
import org.elasticsearch.shield.support.Validation;

public class ESUsersTool
extends CliTool {
    private static final CliToolConfig CONFIG = CliToolConfig.config((String)"esusers", ESUsersTool.class).cmds(new CliToolConfig.Cmd[]{Useradd.access$000(), Userdel.access$100(), Passwd.access$200(), Roles.access$300(), ListUsersAndRoles.access$400()}).build();

    public static void main(String[] args) {
        CliTool.ExitStatus exitStatus = new ESUsersTool().execute(args);
        ESUsersTool.exit(exitStatus.status());
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    private static void exit(int status) {
        System.exit(status);
    }

    public ESUsersTool() {
        super(CONFIG);
    }

    public ESUsersTool(Terminal terminal) {
        super(CONFIG, terminal);
    }

    protected CliTool.Command parse(String cmdName, CommandLine cli) throws Exception {
        switch (cmdName.toLowerCase(Locale.ROOT)) {
            case "useradd": {
                return Useradd.parse(this.terminal, cli);
            }
            case "userdel": {
                return Userdel.parse(this.terminal, cli);
            }
            case "passwd": {
                return Passwd.parse(this.terminal, cli);
            }
            case "list": {
                return ListUsersAndRoles.parse(this.terminal, cli);
            }
            case "roles": {
                return Roles.parse(this.terminal, cli);
            }
        }
        assert (false) : "should never get here, if the user enters an unknown command, an error message should be shown before parse is called";
        return null;
    }

    private static ImmutableSet<String> loadRoleNames(Terminal terminal, Settings settings, Environment env) {
        Path rolesFile = FileRolesStore.resolveFile(settings, env);
        try {
            return FileRolesStore.parseFileForRoleNames(rolesFile, NoOpLogger.INSTANCE);
        }
        catch (Throwable t) {
            terminal.println("Warning:  Could not parse [%s] for roles verification. Please revise and fix it. Nonetheless, the user will still be associated with all specified roles", new Object[]{rolesFile.toAbsolutePath()});
            return null;
        }
    }

    private static String[] markUnknownRoles(String[] roles, Set<String> unknownRoles) {
        if (unknownRoles.isEmpty()) {
            return roles;
        }
        String[] marked = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            marked[i] = unknownRoles.contains(roles[i]) ? roles[i] + "*" : roles[i];
        }
        return marked;
    }

    private static void verifyRoles(Terminal terminal, Settings settings, Environment env, String[] roles) {
        ImmutableSet<String> knownRoles = ESUsersTool.loadRoleNames(terminal, settings, env);
        Sets.SetView unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), knownRoles);
        if (!unknownRoles.isEmpty()) {
            Path rolesFile = FileRolesStore.resolveFile(settings, env);
            terminal.println("Warning: The following roles [%s] are unknown. Make sure to add them to the [%s] file. Nonetheless the user will still be associated with all specified roles", new Object[]{Strings.collectionToCommaDelimitedString((Iterable)unknownRoles), rolesFile.toAbsolutePath()});
        }
    }

    static class ListUsersAndRoles
    extends CliTool.Command {
        private static final String NAME = "list";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"list", Useradd.class).build();
        String username;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String username = null;
            if (cli.getArgs().length == 1) {
                username = cli.getArgs()[0];
            } else if (cli.getArgs().length > 1) {
                Object[] extra = Arrays.copyOfRange(cli.getArgs(), 1, cli.getArgs().length);
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)("extra arguments " + Arrays.toString(extra) + " were provided. list can be used without a user or with a single user"), (Object[])new Object[0]);
            }
            return new ListUsersAndRoles(terminal, username);
        }

        public ListUsersAndRoles(Terminal terminal, String username) {
            super(terminal);
            this.username = username;
        }

        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            ImmutableSet knownRoles = ESUsersTool.loadRoleNames(this.terminal, settings, env);
            Path userRolesFilePath = FileUserRolesStore.resolveFile(esusersSettings, env);
            ImmutableMap<String, String[]> userRoles = FileUserRolesStore.parseFile(userRolesFilePath, null);
            Path userFilePath = FileUserPasswdStore.resolveFile(esusersSettings, env);
            ImmutableSet users = FileUserPasswdStore.parseFile(userFilePath, null).keySet();
            if (this.username != null) {
                if (!users.contains(this.username)) {
                    this.terminal.println("User [%s] doesn't exist", new Object[]{this.username});
                    return CliTool.ExitStatus.NO_USER;
                }
                if (userRoles.containsKey(this.username)) {
                    Object[] roles = (String[])userRoles.get(this.username);
                    Sets.SetView unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), (Set)knownRoles);
                    Object[] markedRoles = ESUsersTool.markUnknownRoles((String[])roles, (Set)unknownRoles);
                    this.terminal.println("%-15s: %s", new Object[]{this.username, Joiner.on((String)",").useForNull("-").join(markedRoles)});
                    if (!unknownRoles.isEmpty()) {
                        Path rolesFile = FileRolesStore.resolveFile(esusersSettings, env).toAbsolutePath();
                        this.terminal.println();
                        this.terminal.println(" [*]   An unknown role. Please check [%s] to see available roles", new Object[]{rolesFile.toAbsolutePath()});
                    }
                } else {
                    this.terminal.println("%-15s: -", new Object[]{this.username});
                }
            } else {
                boolean unknownRolesFound = false;
                boolean usersExist = false;
                for (Map.Entry entry : userRoles.entrySet()) {
                    Object[] roles = (String[])entry.getValue();
                    Sets.SetView unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), (Set)knownRoles);
                    Object[] markedRoles = ESUsersTool.markUnknownRoles((String[])roles, (Set)unknownRoles);
                    this.terminal.println("%-15s: %s", new Object[]{entry.getKey(), Joiner.on((String)",").join(markedRoles)});
                    unknownRolesFound = unknownRolesFound || !unknownRoles.isEmpty();
                    usersExist = true;
                }
                HashSet usersWithoutRoles = Sets.newHashSet((Iterable)users);
                usersWithoutRoles.removeAll(userRoles.keySet());
                for (String user : usersWithoutRoles) {
                    this.terminal.println("%-15s: -", new Object[]{user});
                    usersExist = true;
                }
                if (!usersExist) {
                    this.terminal.println("No users found", new Object[0]);
                    return CliTool.ExitStatus.OK;
                }
                if (unknownRolesFound) {
                    Path rolesFile = FileRolesStore.resolveFile(esusersSettings, env).toAbsolutePath();
                    this.terminal.println();
                    this.terminal.println(" [*]   An unknown role. Please check [%s] to see available roles", new Object[]{rolesFile.toAbsolutePath()});
                }
            }
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$400() {
            return CMD;
        }
    }

    static class Roles
    extends CheckFileCommand {
        private static final String NAME = "roles";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"roles", Roles.class).options(new CliToolConfig.OptionBuilder[]{CliToolConfig.Builder.option((String)"a", (String)"add").hasArg(true).required(false), CliToolConfig.Builder.option((String)"r", (String)"remove").hasArg(true).required(false)}).build();
        public static final Pattern ROLE_PATTERN = Pattern.compile("[\\w@-]+");
        final String username;
        final String[] addRoles;
        final String[] removeRoles;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            if (cli.getArgs().length == 0) {
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"username is missing", (Object[])new Object[0]);
            }
            if (cli.getArgs().length != 1) {
                Object[] extra = Arrays.copyOfRange(cli.getArgs(), 1, cli.getArgs().length);
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)("extra arguments " + Arrays.toString(extra) + " were provided. please ensure all special characters are escaped"), (Object[])new Object[0]);
            }
            String username = cli.getArgs()[0];
            String addRolesCsv = cli.getOptionValue("add");
            String[] addRoles = addRolesCsv != null ? addRolesCsv.split(",") : Strings.EMPTY_ARRAY;
            String removeRolesCsv = cli.getOptionValue("remove");
            String[] removeRoles = removeRolesCsv != null ? removeRolesCsv.split(",") : Strings.EMPTY_ARRAY;
            return new Roles(terminal, username, addRoles, removeRoles);
        }

        public Roles(Terminal terminal, String username, String[] addRoles, String[] removeRoles) {
            super(terminal);
            this.username = username;
            this.addRoles = addRoles;
            this.removeRoles = removeRoles;
        }

        protected Path[] pathsForPermissionsCheck(Settings settings, Environment env) {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path path = FileUserPasswdStore.resolveFile(esusersSettings, env);
            return new Path[]{path};
        }

        public CliTool.ExitStatus doExecute(Settings settings, Environment env) throws Exception {
            String[] allRoles;
            boolean readOnlyUserListing;
            boolean bl = readOnlyUserListing = this.removeRoles.length == 0 && this.addRoles.length == 0;
            if (readOnlyUserListing) {
                return new ListUsersAndRoles(this.terminal, this.username).execute(settings, env);
            }
            for (String role : allRoles = (String[])ObjectArrays.concat((Object[])this.addRoles, (Object[])this.removeRoles, String.class)) {
                if (ROLE_PATTERN.matcher(role).matches()) continue;
                this.terminal.println("Role name [%s] is not valid. Please use lowercase and numbers only", new Object[]{role});
                return CliTool.ExitStatus.DATA_ERROR;
            }
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path path = FileUserPasswdStore.resolveFile(esusersSettings, env);
            ImmutableMap<String, char[]> usersMap = FileUserPasswdStore.parseFile(path, null);
            if (!usersMap.containsKey(this.username)) {
                this.terminal.println("User [%s] doesn't exist", new Object[]{this.username});
                return CliTool.ExitStatus.NO_USER;
            }
            Path file = FileUserRolesStore.resolveFile(esusersSettings, env);
            ImmutableMap<String, String[]> userRoles = FileUserRolesStore.parseFile(file, null);
            ArrayList<Object> roles = new ArrayList<Object>();
            if (userRoles.get(this.username) != null) {
                roles.addAll(Arrays.asList((Object[])userRoles.get(this.username)));
            }
            ESUsersTool.verifyRoles(this.terminal, settings, env, this.addRoles);
            roles.addAll(Arrays.asList(this.addRoles));
            roles.removeAll(Arrays.asList(this.removeRoles));
            HashMap userRolesToWrite = Maps.newHashMapWithExpectedSize((int)userRoles.size());
            userRolesToWrite.putAll(userRoles);
            if (roles.size() == 0) {
                userRolesToWrite.remove(this.username);
            } else {
                userRolesToWrite.put(this.username, Sets.newLinkedHashSet(roles).toArray(new String[0]));
            }
            FileUserRolesStore.writeFile(userRolesToWrite, file);
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$300() {
            return CMD;
        }
    }

    static class Passwd
    extends CheckFileCommand {
        private static final String NAME = "passwd";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"passwd", Passwd.class).options(new CliToolConfig.OptionBuilder[]{CliToolConfig.Builder.option((String)"p", (String)"password").hasArg(false).required(false)}).build();
        final String username;
        final SecuredString passwd;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            char[] password;
            if (cli.getArgs().length == 0) {
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"username is missing", (Object[])new Object[0]);
            }
            if (cli.getArgs().length != 1) {
                Object[] extra = Arrays.copyOfRange(cli.getArgs(), 1, cli.getArgs().length);
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)("extra arguments " + Arrays.toString(extra) + " were provided"), (Object[])new Object[0]);
            }
            String username = cli.getArgs()[0];
            String passwordStr = cli.getOptionValue("password");
            if (passwordStr != null) {
                password = passwordStr.toCharArray();
            } else {
                char[] retyped;
                password = terminal.readSecret("Enter new password: ", new Object[0]);
                if (!Arrays.equals(password, retyped = terminal.readSecret("Retype new password: ", new Object[0]))) {
                    return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"Password mismatch", (Object[])new Object[0]);
                }
            }
            return new Passwd(terminal, username, password);
        }

        Passwd(Terminal terminal, String username, char[] passwd) {
            super(terminal);
            this.username = username;
            this.passwd = new SecuredString(passwd);
            Arrays.fill(passwd, '\u0000');
        }

        protected Path[] pathsForPermissionsCheck(Settings settings, Environment env) {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path path = FileUserPasswdStore.resolveFile(esusersSettings, env);
            return new Path[]{path};
        }

        public CliTool.ExitStatus doExecute(Settings settings, Environment env) throws Exception {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path file = FileUserPasswdStore.resolveFile(esusersSettings, env);
            HashMap<String, char[]> users = new HashMap<String, char[]>((Map<String, char[]>)FileUserPasswdStore.parseFile(file, null));
            if (!users.containsKey(this.username)) {
                this.terminal.println("User [%s] doesn't exist", new Object[]{this.username});
                return CliTool.ExitStatus.NO_USER;
            }
            Hasher hasher = Hasher.BCRYPT;
            users.put(this.username, hasher.hash(this.passwd));
            FileUserPasswdStore.writeFile(users, file);
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$200() {
            return CMD;
        }
    }

    static class Userdel
    extends CheckFileCommand {
        private static final String NAME = "userdel";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"userdel", Userdel.class).build();
        final String username;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            if (cli.getArgs().length == 0) {
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"username is missing", (Object[])new Object[0]);
            }
            if (cli.getArgs().length != 1) {
                Object[] extra = Arrays.copyOfRange(cli.getArgs(), 1, cli.getArgs().length);
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)("extra arguments " + Arrays.toString(extra) + " were provided. userdel only supports deleting one user at a time"), (Object[])new Object[0]);
            }
            String username = cli.getArgs()[0];
            return new Userdel(terminal, username);
        }

        Userdel(Terminal terminal, String username) {
            super(terminal);
            this.username = username;
        }

        protected Path[] pathsForPermissionsCheck(Settings settings, Environment env) {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path userPath = FileUserPasswdStore.resolveFile(esusersSettings, env);
            Path userRolesPath = FileUserRolesStore.resolveFile(esusersSettings, env);
            if (Files.exists(userRolesPath, new LinkOption[0])) {
                return new Path[]{userPath, userRolesPath};
            }
            return new Path[]{userPath};
        }

        public CliTool.ExitStatus doExecute(Settings settings, Environment env) throws Exception {
            String[] roles;
            char[] passwd;
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path file = FileUserPasswdStore.resolveFile(esusersSettings, env);
            HashMap<String, char[]> users = new HashMap<String, char[]>((Map<String, char[]>)FileUserPasswdStore.parseFile(file, null));
            if (!users.containsKey(this.username)) {
                this.terminal.println("User [%s] doesn't exist", new Object[]{this.username});
                return CliTool.ExitStatus.NO_USER;
            }
            if (Files.exists(file, new LinkOption[0]) && (passwd = (char[])users.remove(this.username)) != null) {
                FileUserPasswdStore.writeFile(users, file);
            }
            file = FileUserRolesStore.resolveFile(esusersSettings, env);
            HashMap<String, String[]> userRoles = new HashMap<String, String[]>((Map<String, String[]>)FileUserRolesStore.parseFile(file, null));
            if (Files.exists(file, new LinkOption[0]) && (roles = (String[])userRoles.remove(this.username)) != null) {
                FileUserRolesStore.writeFile(userRoles, file);
            }
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$100() {
            return CMD;
        }
    }

    static class Useradd
    extends CheckFileCommand {
        private static final String NAME = "useradd";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"useradd", Useradd.class).options(new CliToolConfig.OptionBuilder[]{CliToolConfig.Builder.option((String)"p", (String)"password").hasArg(false).required(false), CliToolConfig.Builder.option((String)"r", (String)"roles").hasArg(false).required(false)}).build();
        final String username;
        final SecuredString passwd;
        final String[] roles;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String rolesCsv;
            String[] roles;
            char[] password;
            if (cli.getArgs().length == 0) {
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"username is missing", (Object[])new Object[0]);
            }
            if (cli.getArgs().length != 1) {
                Object[] extra = Arrays.copyOfRange(cli.getArgs(), 1, cli.getArgs().length);
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)("extra arguments " + Arrays.toString(extra) + " were provided. please ensure all special characters are escaped"), (Object[])new Object[0]);
            }
            String username = cli.getArgs()[0];
            Validation.Error validationError = Validation.ESUsers.validateUsername(username);
            if (validationError != null) {
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.DATA_ERROR, (Terminal)terminal, (String)("Invalid username [" + username + "]... " + validationError), (Object[])new Object[0]);
            }
            String passwordStr = cli.getOptionValue("password");
            if (passwordStr != null) {
                password = passwordStr.toCharArray();
                validationError = Validation.ESUsers.validatePassword(password);
                if (validationError != null) {
                    return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.DATA_ERROR, (Terminal)terminal, (String)("Invalid password..." + validationError), (Object[])new Object[0]);
                }
            } else {
                password = terminal.readSecret("Enter new password: ", new Object[0]);
                validationError = Validation.ESUsers.validatePassword(password);
                if (validationError != null) {
                    return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.DATA_ERROR, (Terminal)terminal, (String)("Invalid password..." + validationError), (Object[])new Object[0]);
                }
                char[] retyped = terminal.readSecret("Retype new password: ", new Object[0]);
                if (!Arrays.equals(password, retyped)) {
                    return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.USAGE, (Terminal)terminal, (String)"Password mismatch", (Object[])new Object[0]);
                }
            }
            for (String role : roles = (rolesCsv = cli.getOptionValue("roles")) != null ? rolesCsv.split(",") : Strings.EMPTY_ARRAY) {
                validationError = Validation.Roles.validateRoleName(role);
                if (validationError == null) continue;
                return ESUsersTool.exitCmd((CliTool.ExitStatus)CliTool.ExitStatus.DATA_ERROR, (Terminal)terminal, (String)("Invalid role [" + role + "]... " + validationError), (Object[])new Object[0]);
            }
            return new Useradd(terminal, username, new SecuredString(password), roles);
        }

        Useradd(Terminal terminal, String username, SecuredString passwd, String ... roles) {
            super(terminal);
            this.username = username;
            this.passwd = passwd;
            this.roles = roles;
        }

        public CliTool.ExitStatus doExecute(Settings settings, Environment env) throws Exception {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            ESUsersTool.verifyRoles(this.terminal, settings, env, this.roles);
            Path file = FileUserPasswdStore.resolveFile(esusersSettings, env);
            HashMap<String, char[]> users = new HashMap<String, char[]>((Map<String, char[]>)FileUserPasswdStore.parseFile(file, null));
            if (users.containsKey(this.username)) {
                this.terminal.println("User [%s] already exists", new Object[]{this.username});
                return CliTool.ExitStatus.CODE_ERROR;
            }
            Hasher hasher = Hasher.BCRYPT;
            users.put(this.username, hasher.hash(this.passwd));
            FileUserPasswdStore.writeFile(users, file);
            if (this.roles != null && this.roles.length > 0) {
                file = FileUserRolesStore.resolveFile(esusersSettings, env);
                HashMap<String, String[]> userRoles = new HashMap<String, String[]>((Map<String, String[]>)FileUserRolesStore.parseFile(file, null));
                userRoles.put(this.username, this.roles);
                FileUserRolesStore.writeFile(userRoles, file);
            }
            return CliTool.ExitStatus.OK;
        }

        protected Path[] pathsForPermissionsCheck(Settings settings, Environment env) {
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path userPath = FileUserPasswdStore.resolveFile(esusersSettings, env);
            Path userRolesPath = FileUserRolesStore.resolveFile(esusersSettings, env);
            return new Path[]{userPath, userRolesPath};
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }
}

