/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.authc.esusers.tool;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.authc.Realms;
import org.elasticsearch.shield.authc.esusers.FileUserPasswdStore;
import org.elasticsearch.shield.authc.esusers.FileUserRolesStore;
import org.elasticsearch.shield.authz.RoleDescriptor;
import org.elasticsearch.shield.authz.store.FileRolesStore;
import org.elasticsearch.shield.support.NoOpLogger;

public class ESNativeRealmMigrateTool
extends CliTool {
    private static final CliToolConfig CONFIG = CliToolConfig.config((String)"migrate", ESNativeRealmMigrateTool.class).cmds(new CliToolConfig.Cmd[]{NoopCmd.access$000(), MigrateUserOrRoles.access$100()}).build();

    public ESNativeRealmMigrateTool() {
        super(CONFIG);
    }

    public ESNativeRealmMigrateTool(Terminal terminal) {
        super(CONFIG, terminal);
    }

    public static void main(String[] args) {
        CliTool.ExitStatus exitStatus = new ESNativeRealmMigrateTool().execute(args);
        ESNativeRealmMigrateTool.exit(exitStatus.status());
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    private static void exit(int status) {
        System.exit(status);
    }

    protected CliTool.Command parse(String cmdName, CommandLine cli) throws Exception {
        return MigrateUserOrRoles.parse(this.terminal, cli);
    }

    public static class MigrateUserOrRoles
    extends CliTool.Command {
        private static final String NAME = "native";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"native", MigrateUserOrRoles.class).options(new CliToolConfig.OptionBuilder[]{CliToolConfig.Builder.option((String)"u", (String)"username").hasArg(true).required(false), CliToolConfig.Builder.option((String)"p", (String)"password").hasArg(true).required(false), CliToolConfig.Builder.option((String)"n", (String)"users").hasArg(true).required(false), CliToolConfig.Builder.option((String)"r", (String)"roles").hasArg(true).required(false), CliToolConfig.Builder.option((String)"U", (String)"url").hasArg(true).required(true), CliToolConfig.Builder.option((String)"c", (String)"config").hasArg(true).required(false)}).build();
        String username;
        String password;
        String url;
        String[] usersToMigrate;
        String[] rolesToMigrate;
        String esConfigDir;

        public MigrateUserOrRoles(Terminal terminal, String username, String password, String url, String[] usersToMigrate, String[] rolesToMigrate, String esConfigDir) {
            super(terminal);
            this.username = username;
            this.password = password;
            this.url = url;
            this.usersToMigrate = usersToMigrate;
            this.rolesToMigrate = rolesToMigrate;
            this.esConfigDir = esConfigDir;
        }

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String username = cli.getOptionValue("username");
            String password = cli.getOptionValue("password");
            String url = cli.getOptionValue("url");
            String esConfigDir = cli.getOptionValue("config");
            String usersCsv = cli.getOptionValue("users");
            String rolesCsv = cli.getOptionValue("roles");
            String[] usersToMigrate = usersCsv != null ? usersCsv.split(",") : Strings.EMPTY_ARRAY;
            String[] rolesToMigrate = rolesCsv != null ? rolesCsv.split(",") : Strings.EMPTY_ARRAY;
            return new MigrateUserOrRoles(terminal, username, password, url, usersToMigrate, rolesToMigrate, esConfigDir);
        }

        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            this.terminal.println("starting migration of users and roles...", new Object[0]);
            Environment shieldEnv = env;
            Settings shieldSettings = settings;
            if (this.esConfigDir != null) {
                shieldSettings = Settings.builder().put(settings).put("path.conf", this.esConfigDir).build();
                shieldEnv = new Environment(shieldSettings);
            }
            this.importUsers(settings, shieldEnv);
            this.importRoles(settings, shieldEnv);
            this.terminal.println("users and roles imported.", new Object[0]);
            return CliTool.ExitStatus.OK;
        }

        /*
         * Exception decompiling
         */
        private String postURL(Settings settings, Environment env, String method, String urlString, @Nullable String bodyString) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Set<String> getUsersThatExist(Settings settings, Environment env) throws Exception {
            HashSet<String> existingUsers;
            block14: {
                existingUsers = new HashSet<String>();
                String allUsersJson = this.postURL(settings, env, "GET", this.url + "/_shield/user/", null);
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(allUsersJson);){
                    XContentParser.Token token = parser.nextToken();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                            String userName = parser.currentName();
                            existingUsers.add(userName);
                            parser.nextToken();
                            parser.skipChildren();
                        }
                        break block14;
                    }
                    throw new Exception("failed to retrieve users, expecting an object but got: " + token);
                }
            }
            this.terminal.println("found existing users: %s", new Object[]{existingUsers});
            return existingUsers;
        }

        public static String createUserJson(String[] roles, char[] password) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.field("password_hash", new String(password));
            builder.startArray("roles");
            for (String role : roles) {
                builder.value(role);
            }
            builder.endArray();
            builder.endObject();
            return builder.string();
        }

        public void importUsers(Settings settings, Environment env) {
            Set<String> existingUsers;
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path usersFile = FileUserPasswdStore.resolveFile(esusersSettings, env);
            Path usersRolesFile = FileUserRolesStore.resolveFile(esusersSettings, env);
            this.terminal.println("importing users from [%s]...", new Object[]{usersFile});
            ImmutableMap<String, char[]> userToHashedPW = FileUserPasswdStore.parseFile(usersFile, null);
            ImmutableMap<String, String[]> userToRoles = FileUserRolesStore.parseFile(usersRolesFile, null);
            try {
                existingUsers = this.getUsersThatExist(settings, env);
            }
            catch (Exception e) {
                this.terminal.println("failed to get users that already exist, skipping user import", new Object[0]);
                this.terminal.println(ExceptionsHelper.stackTrace((Throwable)e), new Object[0]);
                return;
            }
            if (this.usersToMigrate.length == 0) {
                this.usersToMigrate = userToHashedPW.keySet().toArray(new String[userToHashedPW.size()]);
            }
            for (String user : this.usersToMigrate) {
                if (!userToHashedPW.containsKey(user)) {
                    this.terminal.println("no user [%s] found, skipping", new Object[]{user});
                    continue;
                }
                if (existingUsers.contains(user)) {
                    this.terminal.println("user [%s] already exists, skipping", new Object[]{user});
                    continue;
                }
                this.terminal.println("migrating user [%s]", new Object[]{user});
                String reqBody = "n/a";
                try {
                    reqBody = MigrateUserOrRoles.createUserJson((String[])userToRoles.get(user), (char[])userToHashedPW.get(user));
                    String resp = this.postURL(settings, env, "POST", this.url + "/_shield/user/" + user, reqBody);
                    this.terminal.println(resp, new Object[0]);
                }
                catch (Exception e) {
                    this.terminal.println("failed to migrate user [%s] with body: %s", new Object[]{user, reqBody});
                    this.terminal.println(ExceptionsHelper.stackTrace((Throwable)e), new Object[0]);
                }
            }
        }

        public Set<String> getRolesThatExist(Settings settings, Environment env) throws Exception {
            HashSet<String> existingRoles;
            block14: {
                existingRoles = new HashSet<String>();
                String allRolesJson = this.postURL(settings, env, "GET", this.url + "/_shield/role/", null);
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(allRolesJson);){
                    XContentParser.Token token = parser.nextToken();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                            String roleName = parser.currentName();
                            existingRoles.add(roleName);
                            parser.nextToken();
                            parser.skipChildren();
                        }
                        break block14;
                    }
                    throw new Exception("failed to retrieve roles, expecting an object but got: " + token);
                }
            }
            this.terminal.println("found existing roles: %s", new Object[]{existingRoles});
            return existingRoles;
        }

        public static String createRoleJson(RoleDescriptor rd) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            String[] clusterStrings = rd.getClusterPrivileges();
            String[] runAs = rd.getRunAs();
            RoleDescriptor.IndicesPrivileges[] indicesPrivileges = rd.getIndicesPrivileges();
            if (clusterStrings != null && clusterStrings.length > 0) {
                builder.array("cluster", clusterStrings);
            }
            if (runAs != null && runAs.length > 0) {
                builder.array("run_as", runAs);
            }
            if (indicesPrivileges != null && indicesPrivileges.length > 0) {
                builder.startArray("indices");
                for (RoleDescriptor.IndicesPrivileges ip : indicesPrivileges) {
                    builder.startObject();
                    String[] indices = ip.getIndices();
                    String[] privs = ip.getPrivileges();
                    String[] fields = ip.getFields();
                    BytesReference query = ip.getQuery();
                    if (indices != null && indices.length > 0) {
                        builder.array("names", indices);
                    }
                    if (privs != null && privs.length > 0) {
                        builder.array("privileges", privs);
                    }
                    if (fields != null && fields.length > 0) {
                        builder.array("fields", fields);
                    }
                    if (query != null) {
                        builder.field("query", query.toUtf8());
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
            builder.endObject();
            return builder.string();
        }

        public void importRoles(Settings settings, Environment env) {
            Set<String> existingRoles;
            Settings esusersSettings = Realms.fileRealmSettings(settings);
            Path rolesFile = FileRolesStore.resolveFile(esusersSettings, env).toAbsolutePath();
            this.terminal.println("importing roles from [%s]...", new Object[]{rolesFile});
            ImmutableMap<String, RoleDescriptor> roles = FileRolesStore.parseRoleDescriptors(rolesFile, null, Settings.EMPTY, new DeprecationLogger(NoOpLogger.INSTANCE));
            try {
                existingRoles = this.getRolesThatExist(settings, env);
            }
            catch (Exception e) {
                this.terminal.println("failed to get roles that already exist, skipping role import", new Object[0]);
                this.terminal.println(ExceptionsHelper.stackTrace((Throwable)e), new Object[0]);
                return;
            }
            if (this.rolesToMigrate.length == 0) {
                this.rolesToMigrate = roles.keySet().toArray(new String[roles.size()]);
            }
            for (String roleName : this.rolesToMigrate) {
                if (!roles.containsKey(roleName)) {
                    this.terminal.println("no role [%s] found, skipping", new Object[]{roleName});
                    continue;
                }
                if (existingRoles.contains(roleName)) {
                    this.terminal.println("role [%s] already exists, skipping", new Object[]{roleName});
                    continue;
                }
                this.terminal.println("migrating role [%s]", new Object[]{roleName});
                String reqBody = "n/a";
                try {
                    reqBody = MigrateUserOrRoles.createRoleJson((RoleDescriptor)roles.get(roleName));
                    String resp = this.postURL(settings, env, "POST", this.url + "/_shield/role/" + roleName, reqBody);
                    this.terminal.println(resp, new Object[0]);
                }
                catch (Exception e) {
                    this.terminal.println("failed to migrate role [%s] with body: %s", new Object[]{roleName, reqBody});
                    this.terminal.println(ExceptionsHelper.stackTrace((Throwable)e), new Object[0]);
                }
            }
        }

        static /* synthetic */ CliToolConfig.Cmd access$100() {
            return CMD;
        }
    }

    static class NoopCmd
    extends CliTool.Command {
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd((String)"noop", NoopCmd.class).build();

        public NoopCmd(Terminal terminal) {
            super(terminal);
        }

        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }
}

