/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action.interceptor;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.support.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.interceptor.RequestInterceptor;
import org.elasticsearch.shield.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.transport.TransportRequest;

public abstract class FieldAndDocumentLevelSecurityRequestInterceptor<Request>
extends AbstractComponent
implements RequestInterceptor<Request> {
    public FieldAndDocumentLevelSecurityRequestInterceptor(Settings settings) {
        super(settings);
    }

    @Override
    public void intercept(Request request, User user) {
        List<IndicesRequest> indicesRequests;
        if (request instanceof CompositeIndicesRequest) {
            indicesRequests = ((CompositeIndicesRequest)request).subRequests();
        } else if (request instanceof IndicesRequest) {
            indicesRequests = Collections.singletonList((IndicesRequest)request);
        } else {
            throw new IllegalArgumentException(LoggerMessageFormat.format((String)"Expected a request of type [{}] or [{}] but got [{}] instead", (Object[])new Object[]{CompositeIndicesRequest.class, IndicesRequest.class, request.getClass()}));
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)((TransportRequest)request).getFromContext((Object)"_indices_permissions");
        for (IndicesRequest indicesRequest : indicesRequests) {
            for (String index : indicesRequest.indices()) {
                IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                if (indexAccessControl != null) {
                    boolean dls;
                    boolean fls = indexAccessControl.getFields() != null;
                    boolean bl = dls = indexAccessControl.getQueries() != null;
                    if (fls || dls) {
                        this.logger.debug("intercepted request for index [{}] with field level or document level security enabled, disabling features", new Object[]{index});
                        this.disableFeatures(request);
                        return;
                    }
                }
                this.logger.trace("intercepted request for index [{}] with neither field level or document level security not enabled, doing nothing", new Object[]{index});
            }
        }
    }

    protected abstract void disableFeatures(Request var1);
}

