/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.action;

import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.license.plugin.action.get.GetLicenseRequest;
import org.elasticsearch.transport.TransportRequest;

public class ShieldActionMapper {
    static final String CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME = "cluster:admin/indices/scroll/clear_all";
    static final String CLUSTER_PERMISSION_ANALYZE = "cluster:admin/analyze";
    static final String CLUSTER_MONITOR_LICENSE_NAME = "cluster:monitor/plugin/license/get";

    public String action(String action, TransportRequest request) {
        switch (action) {
            case "indices:data/read/scroll/clear": {
                assert (request instanceof ClearScrollRequest);
                boolean isClearAllScrollRequest = ((ClearScrollRequest)request).scrollIds().contains("_all");
                if (!isClearAllScrollRequest) break;
                return CLUSTER_PERMISSION_SCROLL_CLEAR_ALL_NAME;
            }
            case "indices:admin/analyze": 
            case "indices:admin/analyze[s]": {
                assert (request instanceof AnalyzeRequest);
                String[] indices = ((AnalyzeRequest)request).indices();
                if (indices != null && (indices.length != 1 || indices[0] != null)) break;
                return CLUSTER_PERMISSION_ANALYZE;
            }
            case "cluster:admin/plugin/license/get": {
                assert (request instanceof GetLicenseRequest);
                return CLUSTER_MONITOR_LICENSE_NAME;
            }
        }
        return action;
    }
}

