/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class ShieldBuild {
    public static final ShieldBuild CURRENT;
    private String hash;
    private String hashShort;
    private String timestamp;

    ShieldBuild(String hash, String hashShort, String timestamp) {
        this.hash = hash;
        this.hashShort = hashShort;
        this.timestamp = timestamp;
    }

    public String hash() {
        return this.hash;
    }

    public String hashShort() {
        return this.hashShort;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public static ShieldBuild readBuild(StreamInput in) throws IOException {
        String hash = in.readString();
        String hashShort = in.readString();
        String timestamp = in.readString();
        return new ShieldBuild(hash, hashShort, timestamp);
    }

    public static void writeBuild(ShieldBuild build, StreamOutput out) throws IOException {
        out.writeString(build.hash());
        out.writeString(build.hashShort());
        out.writeString(build.timestamp());
    }

    static {
        String hash = "NA";
        String hashShort = "NA";
        String timestamp = "NA";
        try (InputStream is = ShieldBuild.class.getResourceAsStream("/shield-build.properties");){
            String gitTimestampRaw;
            Properties props = new Properties();
            props.load(is);
            hash = props.getProperty("hash", hash);
            if (!hash.equals("NA")) {
                hashShort = hash.substring(0, 7);
            }
            if ((gitTimestampRaw = props.getProperty("timestamp")) != null) {
                timestamp = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(Long.parseLong(gitTimestampRaw));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CURRENT = new ShieldBuild(hash, hashShort, timestamp);
    }
}

