/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ClientScrollableHitSource;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkingBulkByScrollTask;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>> {
    protected final Logger logger;
    protected final WorkingBulkByScrollTask task;
    protected final ThreadPool threadPool;
    protected final ScriptService scriptService;
    protected final ClusterState clusterState;
    protected final Request mainRequest;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ParentTaskAssigningClient client;
    private final ActionListener<BulkByScrollResponse> listener;
    private final Retry bulkRetry;
    private final ScrollableHitSource scrollSource;
    private final BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> scriptApplier;

    public AbstractAsyncBulkByScrollAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        this.task = task;
        this.logger = logger;
        this.client = client;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.clusterState = clusterState;
        this.mainRequest = mainRequest;
        this.listener = listener;
        BackoffPolicy backoffPolicy = this.buildBackoffPolicy();
        this.bulkRetry = Retry.on(EsRejectedExecutionException.class).policy(BackoffPolicy.wrap((BackoffPolicy)backoffPolicy, () -> ((WorkingBulkByScrollTask)task).countBulkRetry()));
        this.scrollSource = this.buildScrollableResultSource(backoffPolicy);
        this.scriptApplier = Objects.requireNonNull(this.buildScriptApplier(), "script applier must not be null");
        List sorts = mainRequest.getSearchRequest().source().sorts();
        if (sorts == null || sorts.isEmpty()) {
            mainRequest.getSearchRequest().source().sort((SortBuilder)SortBuilders.fieldSort((String)"_doc"));
        }
        mainRequest.getSearchRequest().source().version(Boolean.valueOf(this.needsSourceDocumentVersions()));
    }

    public BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> buildScriptApplier() {
        return (request, searchHit) -> request;
    }

    protected abstract boolean needsSourceDocumentVersions();

    protected abstract RequestWrapper<?> buildRequest(ScrollableHitSource.Hit var1);

    protected RequestWrapper<?> copyMetadata(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        Long ttl;
        request.setParent(doc.getParent());
        this.copyRouting(request, doc.getRouting());
        Long timestamp = doc.getTimestamp();
        if (timestamp != null) {
            request.setTimestamp(timestamp.toString());
        }
        if ((ttl = doc.getTTL()) != null) {
            request.setTtl(ttl);
        }
        return request;
    }

    protected void copyRouting(RequestWrapper<?> request, String routing) {
        request.setRouting(routing);
    }

    protected boolean accept(ScrollableHitSource.Hit doc) {
        if (doc.getSource() == null) {
            throw new IllegalArgumentException("[" + doc.getIndex() + "][" + doc.getType() + "][" + doc.getId() + "] didn't store _source");
        }
        return true;
    }

    private BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> docs) {
        BulkRequest bulkRequest = new BulkRequest();
        for (ScrollableHitSource.Hit hit : docs) {
            RequestWrapper<?> request;
            if (!this.accept(hit) || (request = this.scriptApplier.apply(this.copyMetadata(this.buildRequest(hit), hit), hit)) == null) continue;
            bulkRequest.add(request.self());
        }
        return bulkRequest;
    }

    protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
        return new ClientScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkingBulkByScrollTask)this.task).countSearchRetry(), this::finishHim, this.client, this.mainRequest.getSearchRequest());
    }

    protected BulkByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        return new BulkByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
    }

    public void start() {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            this.scrollSource.start(response -> this.onScrollResponse(TimeValue.timeValueNanos((long)System.nanoTime()), 0, (ScrollableHitSource.Response)response));
        }
        catch (Exception e) {
            this.finishHim(e);
        }
    }

    void onScrollResponse(TimeValue lastBatchStartTime, int lastBatchSize, final ScrollableHitSource.Response response) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        if (response.getFailures().size() > 0 || response.isTimedOut()) {
            this.refreshAndFinish(Collections.emptyList(), response.getFailures(), response.isTimedOut());
            return;
        }
        long total = response.getTotalHits();
        if (this.mainRequest.getSize() > 0) {
            total = Math.min(total, (long)this.mainRequest.getSize());
        }
        this.task.setTotal(total);
        AbstractRunnable prepareBulkRequestRunnable = new AbstractRunnable(){

            protected void doRun() throws Exception {
                AbstractAsyncBulkByScrollAction.this.prepareBulkRequest(TimeValue.timeValueNanos((long)System.nanoTime()), response);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        };
        prepareBulkRequestRunnable = (AbstractRunnable)this.threadPool.getThreadContext().preserveContext((Runnable)prepareBulkRequestRunnable);
        this.task.delayPrepareBulkRequest(this.threadPool, lastBatchStartTime, lastBatchSize, prepareBulkRequestRunnable);
    }

    void prepareBulkRequest(TimeValue thisBatchStartTime, ScrollableHitSource.Response response) {
        BulkRequest request;
        long remaining;
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        if (response.getHits().isEmpty()) {
            this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
            return;
        }
        this.task.countBatch();
        List hits = response.getHits();
        if (this.mainRequest.getSize() != -1 && (remaining = Math.max(0L, (long)this.mainRequest.getSize() - this.task.getSuccessfullyProcessed())) < (long)hits.size()) {
            hits = hits.subList(0, (int)remaining);
        }
        if ((request = this.buildBulk(hits)).requests().isEmpty()) {
            this.startNextScroll(thisBatchStartTime, TimeValue.timeValueNanos((long)System.nanoTime()), 0);
            return;
        }
        request.timeout(this.mainRequest.getTimeout());
        request.waitForActiveShards(this.mainRequest.getWaitForActiveShards());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending [{}] entry, [{}] bulk request", (Object)request.requests().size(), (Object)new ByteSizeValue(request.estimatedSizeInBytes()));
        }
        this.sendBulkRequest(thisBatchStartTime, request);
    }

    void sendBulkRequest(final TimeValue thisBatchStartTime, BulkRequest request) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        this.bulkRetry.withAsyncBackoff((Client)this.client, request, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(thisBatchStartTime, response);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void onBulkResponse(TimeValue thisBatchStartTime, BulkResponse response) {
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case CREATE: 
                    case INDEX: {
                        if (item.getResponse().getResult() == DocWriteResponse.Result.CREATED) {
                            this.task.countCreated();
                            break;
                        }
                        this.task.countUpdated();
                        break;
                    }
                    case UPDATE: {
                        this.task.countUpdated();
                        break;
                    }
                    case DELETE: {
                        this.task.countDeleted();
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            if (this.task.isCancelled()) {
                this.finishHim(null);
                return;
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.refreshAndFinish(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (this.mainRequest.getSize() != -1 && this.task.getSuccessfullyProcessed() >= (long)this.mainRequest.getSize()) {
                this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            this.startNextScroll(thisBatchStartTime, TimeValue.timeValueNanos((long)System.nanoTime()), response.getItems().length);
        }
        catch (Exception t) {
            this.finishHim(t);
        }
    }

    void startNextScroll(TimeValue lastBatchStartTime, TimeValue now, int lastBatchSize) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        TimeValue extraKeepAlive = this.task.throttleWaitTime(lastBatchStartTime, now, lastBatchSize);
        this.scrollSource.startNextScroll(extraKeepAlive, response -> this.onScrollResponse(lastBatchStartTime, lastBatchSize, (ScrollableHitSource.Response)response));
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.task.countVersionConflict();
            if (!this.mainRequest.isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void refreshAndFinish(final List<BulkItemResponse.Failure> indexingFailures, final List<ScrollableHitSource.SearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !this.mainRequest.isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(new String[0]);
        refresh.indices(this.destinationIndices.toArray(new String[this.destinationIndices.size()]));
        this.client.admin().indices().refresh(refresh, (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    protected void finishHim(Exception failure) {
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.scrollSource.close(() -> {
            if (failure == null) {
                BulkByScrollResponse response = this.buildResponse(TimeValue.timeValueNanos((long)(System.nanoTime() - this.startTime.get())), indexingFailures, searchFailures, timedOut);
                this.listener.onResponse((Object)response);
            } else {
                this.listener.onFailure(failure);
            }
        });
    }

    BackoffPolicy buildBackoffPolicy() {
        return BackoffPolicy.exponentialBackoff((TimeValue)this.mainRequest.getRetryBackoffInitialTime(), (int)this.mainRequest.getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    void setScroll(String scroll) {
        this.scrollSource.setScroll(scroll);
    }

    public static RequestWrapper<IndexRequest> wrap(IndexRequest request) {
        return new IndexRequestWrapper(request);
    }

    public static RequestWrapper<DeleteRequest> wrap(DeleteRequest request) {
        return new DeleteRequestWrapper(request);
    }

    public static enum OpType {
        NOOP("noop"),
        INDEX("index"),
        DELETE("delete");

        private final String id;

        private OpType(String id) {
            this.id = id;
        }

        public static OpType fromString(String opType) {
            String lowerOpType;
            switch (lowerOpType = opType.toLowerCase(Locale.ROOT)) {
                case "noop": {
                    return NOOP;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Operation type [" + lowerOpType + "] not allowed, only " + Arrays.toString((Object[])OpType.values()) + " are allowed");
        }

        public String toString() {
            return this.id.toLowerCase(Locale.ROOT);
        }
    }

    public abstract class ScriptApplier
    implements BiFunction<RequestWrapper<?>, ScrollableHitSource.Hit, RequestWrapper<?>> {
        private final WorkingBulkByScrollTask task;
        private final ScriptService scriptService;
        private final Script script;
        private final Map<String, Object> params;
        private ExecutableScript executable;
        private Map<String, Object> context;

        public ScriptApplier(WorkingBulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
            this.task = task;
            this.scriptService = scriptService;
            this.script = script;
            this.params = params;
        }

        @Override
        public RequestWrapper<?> apply(RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
            OpType newOpType;
            if (this.script == null) {
                return request;
            }
            if (this.executable == null) {
                CompiledScript compiled = this.scriptService.compile(this.script, (ScriptContext)ScriptContext.Standard.UPDATE);
                this.executable = this.scriptService.executable(compiled, this.params);
            }
            if (this.context == null) {
                this.context = new HashMap<String, Object>();
            } else {
                this.context.clear();
            }
            this.context.put("_index", doc.getIndex());
            this.context.put("_type", doc.getType());
            this.context.put("_id", doc.getId());
            Long oldVersion = doc.getVersion();
            this.context.put("_version", oldVersion);
            String oldParent = doc.getParent();
            this.context.put("_parent", oldParent);
            String oldRouting = doc.getRouting();
            this.context.put("_routing", oldRouting);
            Long oldTimestamp = doc.getTimestamp();
            this.context.put("_timestamp", oldTimestamp);
            Long oldTTL = doc.getTTL();
            this.context.put("_ttl", oldTTL);
            this.context.put("_source", request.getSource());
            OpType oldOpType = OpType.INDEX;
            this.context.put("op", oldOpType.toString());
            this.executable.setNextVar("ctx", this.context);
            this.executable.run();
            Map resultCtx = (Map)this.executable.unwrap(this.context);
            String newOp = (String)resultCtx.remove("op");
            if (newOp == null) {
                throw new IllegalArgumentException("Script cleared operation type");
            }
            request.setSource((Map)resultCtx.remove("_source"));
            Object newValue = resultCtx.remove("_index");
            if (!doc.getIndex().equals(newValue)) {
                this.scriptChangedIndex(request, newValue);
            }
            newValue = resultCtx.remove("_type");
            if (!doc.getType().equals(newValue)) {
                this.scriptChangedType(request, newValue);
            }
            newValue = resultCtx.remove("_id");
            if (!doc.getId().equals(newValue)) {
                this.scriptChangedId(request, newValue);
            }
            if (!Objects.equals(oldVersion, newValue = resultCtx.remove("_version"))) {
                this.scriptChangedVersion(request, newValue);
            }
            if (!Objects.equals(oldParent, newValue = resultCtx.remove("_parent"))) {
                this.scriptChangedParent(request, newValue);
            }
            if (!Objects.equals(oldRouting, newValue = resultCtx.remove("_routing"))) {
                this.scriptChangedRouting(request, newValue);
            }
            if (!Objects.equals(oldTimestamp, newValue = resultCtx.remove("_timestamp"))) {
                this.scriptChangedTimestamp(request, newValue);
            }
            if (!Objects.equals(oldTTL, newValue = resultCtx.remove("_ttl"))) {
                this.scriptChangedTTL(request, newValue);
            }
            if ((newOpType = OpType.fromString(newOp)) != oldOpType) {
                return this.scriptChangedOpType(request, oldOpType, newOpType);
            }
            if (!resultCtx.isEmpty()) {
                throw new IllegalArgumentException("Invalid fields added to context [" + String.join((CharSequence)",", resultCtx.keySet()) + ']');
            }
            return request;
        }

        protected RequestWrapper<?> scriptChangedOpType(RequestWrapper<?> request, OpType oldOpType, OpType newOpType) {
            switch (newOpType) {
                case NOOP: {
                    this.task.countNoop();
                    return null;
                }
                case DELETE: {
                    RequestWrapper<DeleteRequest> delete = AbstractAsyncBulkByScrollAction.wrap(new DeleteRequest(request.getIndex(), request.getType(), request.getId()));
                    delete.setVersion(request.getVersion());
                    delete.setVersionType(VersionType.INTERNAL);
                    delete.setParent(request.getParent());
                    delete.setRouting(request.getRouting());
                    return delete;
                }
            }
            throw new IllegalArgumentException("Unsupported operation type change from [" + (Object)((Object)oldOpType) + "] to [" + (Object)((Object)newOpType) + "]");
        }

        protected abstract void scriptChangedIndex(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedType(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedId(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedVersion(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedRouting(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedParent(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedTimestamp(RequestWrapper<?> var1, Object var2);

        protected abstract void scriptChangedTTL(RequestWrapper<?> var1, Object var2);
    }

    public static class DeleteRequestWrapper
    implements RequestWrapper<DeleteRequest> {
        private final DeleteRequest request;

        DeleteRequestWrapper(DeleteRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped DeleteRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public void setTimestamp(String timestamp) {
            throw new UnsupportedOperationException("unable to set [timestamp] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setTtl(Long ttl) {
            throw new UnsupportedOperationException("unable to set [ttl] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public Map<String, Object> getSource() {
            throw new UnsupportedOperationException("unable to get source from action request [" + this.request.getClass() + "]");
        }

        @Override
        public void setSource(Map<String, Object> source) {
            throw new UnsupportedOperationException("unable to set [source] on action request [" + this.request.getClass() + "]");
        }

        @Override
        public DeleteRequest self() {
            return this.request;
        }
    }

    public static class IndexRequestWrapper
    implements RequestWrapper<IndexRequest> {
        private final IndexRequest request;

        IndexRequestWrapper(IndexRequest request) {
            this.request = Objects.requireNonNull(request, "Wrapped IndexRequest can not be null");
        }

        @Override
        public void setIndex(String index) {
            this.request.index(index);
        }

        @Override
        public String getIndex() {
            return this.request.index();
        }

        @Override
        public void setType(String type) {
            this.request.type(type);
        }

        @Override
        public String getType() {
            return this.request.type();
        }

        @Override
        public void setId(String id) {
            this.request.id(id);
        }

        @Override
        public String getId() {
            return this.request.id();
        }

        @Override
        public void setVersion(long version) {
            this.request.version(version);
        }

        @Override
        public long getVersion() {
            return this.request.version();
        }

        @Override
        public void setVersionType(VersionType versionType) {
            this.request.versionType(versionType);
        }

        @Override
        public void setParent(String parent) {
            this.request.parent(parent);
        }

        @Override
        public String getParent() {
            return this.request.parent();
        }

        @Override
        public void setRouting(String routing) {
            this.request.routing(routing);
        }

        @Override
        public String getRouting() {
            return this.request.routing();
        }

        @Override
        public Map<String, Object> getSource() {
            return this.request.sourceAsMap();
        }

        @Override
        public void setTimestamp(String timestamp) {
            this.request.timestamp(timestamp);
        }

        @Override
        public void setTtl(Long ttl) {
            if (ttl == null) {
                this.request.ttl((TimeValue)null);
            } else {
                this.request.ttl(ttl.longValue());
            }
        }

        @Override
        public void setSource(Map<String, Object> source) {
            this.request.source(source);
        }

        @Override
        public IndexRequest self() {
            return this.request;
        }
    }

    public static interface RequestWrapper<Self extends DocWriteRequest<?>> {
        public void setIndex(String var1);

        public String getIndex();

        public void setType(String var1);

        public String getType();

        public void setId(String var1);

        public String getId();

        public void setVersion(long var1);

        public long getVersion();

        public void setVersionType(VersionType var1);

        public void setParent(String var1);

        public String getParent();

        public void setRouting(String var1);

        public String getRouting();

        public void setTimestamp(String var1);

        public void setTtl(Long var1);

        public void setSource(Map<String, Object> var1);

        public Map<String, Object> getSource();

        public Self self();
    }
}

