/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkIndexByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.remote.RemoteInfo;
import org.elasticsearch.index.reindex.remote.RemoteScrollableHitSource;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkIndexByScrollResponse> {
    public static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.listSetting((String)"reindex.remote.whitelist", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final AutoCreateIndex autoCreateIndex;
    private final Client client;
    private final Set<String> remoteWhitelist;
    private final HttpServer httpServer;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, @Nullable HttpServer httpServer) {
        super(settings, "indices:data/write/reindex", threadPool, transportService, actionFilters, indexNameExpressionResolver, ReindexRequest::new);
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
        this.remoteWhitelist = new HashSet<String>((Collection)REMOTE_CLUSTER_WHITELIST.get(settings));
        this.httpServer = httpServer;
    }

    protected void doExecute(Task task, ReindexRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        this.checkRemoteWhitelist(request.getRemoteInfo());
        ClusterState state = this.clusterService.state();
        TransportReindexAction.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.indexNameExpressionResolver, this.autoCreateIndex, state);
        ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
        new AsyncIndexBySearchAction((BulkByScrollTask)task, this.logger, client, this.threadPool, request, listener, this.scriptService, state).start();
    }

    protected void doExecute(ReindexRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    private void checkRemoteWhitelist(RemoteInfo remoteInfo) {
        HttpInfo httpInfo;
        TransportAddress publishAddress = null;
        HttpInfo httpInfo2 = httpInfo = this.httpServer == null ? null : this.httpServer.info();
        if (httpInfo != null && httpInfo.getAddress() != null) {
            publishAddress = httpInfo.getAddress().publishAddress();
        }
        TransportReindexAction.checkRemoteWhitelist(this.remoteWhitelist, remoteInfo, publishAddress);
    }

    static void checkRemoteWhitelist(Set<String> whitelist, RemoteInfo remoteInfo, TransportAddress publishAddress) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ':' + remoteInfo.getPort();
        if (whitelist.contains(check)) {
            return;
        }
        if (whitelist.contains("myself") && publishAddress != null && publishAddress.toString().equals(check)) {
            return;
        }
        throw new IllegalArgumentException('[' + check + "] not whitelisted in " + REMOTE_CLUSTER_WHITELIST.getKey());
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)destination)[0];
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + ']');
            throw e;
        }
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, long taskId, List<Thread> threadCollector) {
        Header[] clientHeaders = new Header[remoteInfo.getHeaders().size()];
        int i = 0;
        for (Map.Entry<String, String> header : remoteInfo.getHeaders().entrySet()) {
            clientHeaders[i] = new BasicHeader(header.getKey(), header.getValue());
        }
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(remoteInfo.getHost(), remoteInfo.getPort(), remoteInfo.getScheme())}).setDefaultHeaders(clientHeaders).setHttpClientConfigCallback(c -> {
            if (remoteInfo.getUsername() != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(remoteInfo.getUsername(), remoteInfo.getPassword());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
                c.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            AtomicInteger threads = new AtomicInteger();
            c.setThreadFactory(r -> {
                String name = "es-client-" + taskId + "-" + threads.getAndIncrement();
                Thread t = new Thread(r, name);
                threadCollector.add(t);
                return t;
            });
            c.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            return c;
        }).build();
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkIndexByScrollAction<ReindexRequest> {
        private List<Thread> createdThreads = Collections.emptyList();

        public AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ReindexRequest request, ActionListener<BulkIndexByScrollResponse> listener, ScriptService scriptService, ClusterState clusterState) {
            super(task, logger, client, threadPool, request, listener, scriptService, clusterState);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return ((ReindexRequest)this.mainRequest).getDestination().versionType() != VersionType.INTERNAL;
        }

        @Override
        protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
            if (((ReindexRequest)this.mainRequest).getRemoteInfo() != null) {
                RemoteInfo remoteInfo = ((ReindexRequest)this.mainRequest).getRemoteInfo();
                this.createdThreads = Collections.synchronizedList(new ArrayList());
                RestClient restClient = TransportReindexAction.buildRestClient(remoteInfo, this.task.getId(), this.createdThreads);
                return new RemoteScrollableHitSource(this.logger, backoffPolicy, this.threadPool, this.task::countSearchRetry, this::finishHim, restClient, remoteInfo.getQuery(), ((ReindexRequest)this.mainRequest).getSearchRequest());
            }
            return super.buildScrollableResultSource(backoffPolicy);
        }

        @Override
        void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
            super.finishHim(failure, indexingFailures, searchFailures, timedOut);
            for (Thread thread : this.createdThreads) {
                if (!thread.isAlive()) continue;
                assert (false) : "Failed to properly stop client thread [" + thread.getName() + "]";
                this.logger.error("Failed to properly stop client thread [{}]", (Object)thread.getName());
            }
        }

        @Override
        protected BiFunction<AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((ReindexRequest)this.mainRequest).getScript();
            if (script != null) {
                return new ReindexScriptApplier(this.task, this.scriptService, script, (Map<String, Object>)script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkIndexByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(((ReindexRequest)this.mainRequest).getDestination().index());
            if (((ReindexRequest)this.mainRequest).getDestination().type() == null) {
                index.type(doc.getType());
            } else {
                index.type(((ReindexRequest)this.mainRequest).getDestination().type());
            }
            index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
            if (index.versionType() == VersionType.INTERNAL) {
                assert (doc.getVersion() == -1L) : "fetched version when we didn't have to";
                index.version(((ReindexRequest)this.mainRequest).getDestination().version());
            } else {
                index.version(doc.getVersion());
            }
            index.id(doc.getId());
            index.source(doc.getSource());
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.parent(((ReindexRequest)this.mainRequest).getDestination().parent());
            index.timestamp(((ReindexRequest)this.mainRequest).getDestination().timestamp());
            index.ttl(((ReindexRequest)this.mainRequest).getDestination().ttl());
            index.contentType(((ReindexRequest)this.mainRequest).getDestination().getContentType());
            index.setPipeline(((ReindexRequest)this.mainRequest).getDestination().getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        @Override
        protected void copyRouting(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, String routing) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(request, routing);
                return;
            }
            if (routingSpec.startsWith("=")) {
                super.copyRouting(request, ((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(request, routing);
                    break;
                }
                case "discard": {
                    super.copyRouting(request, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        class ReindexScriptApplier
        extends AbstractAsyncBulkIndexByScrollAction.ScriptApplier {
            ReindexScriptApplier(BulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(task, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination index!");
                request.setIndex(to.toString());
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination type!");
                request.setType(to.toString());
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                request.setId(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setVersion(-3L);
                    request.setVersionType(VersionType.INTERNAL);
                } else {
                    request.setVersion(this.asLong(to, "_version"));
                }
            }

            @Override
            protected void scriptChangedParent(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                String routing = Objects.toString(to, null);
                request.setParent(routing);
                request.setRouting(routing);
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                request.setRouting(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedTimestamp(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                request.setTimestamp(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedTTL(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setTtl(null);
                } else {
                    request.setTtl(this.asLong(to, "_ttl"));
                }
            }

            private long asLong(Object from, String name) {
                Number fromNumber;
                try {
                    fromNumber = (Number)from;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]", e);
                }
                long l = fromNumber.longValue();
                if (fromNumber.doubleValue() != (double)l) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]");
                }
                return l;
            }
        }
    }
}

