/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchRequestParsers;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;

public abstract class AbstractBaseReindexRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends GenericAction<Request, BulkIndexByScrollResponse>>
extends BaseRestHandler {
    protected final SearchRequestParsers searchRequestParsers;
    private final ClusterService clusterService;
    private final A action;

    protected AbstractBaseReindexRestHandler(Settings settings, SearchRequestParsers searchRequestParsers, ClusterService clusterService, A action) {
        super(settings);
        this.searchRequestParsers = searchRequestParsers;
        this.clusterService = clusterService;
        this.action = action;
    }

    protected void handleRequest(RestRequest request, RestChannel channel, NodeClient client, boolean includeCreated, boolean includeUpdated) throws IOException {
        Request internal = this.setCommonOptions(request, this.buildRequest(request));
        if (request.paramAsBoolean("wait_for_completion", true)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("include_created", Boolean.toString(includeCreated));
            params.put("include_updated", Boolean.toString(includeUpdated));
            client.executeLocally(this.action, internal, (ActionListener)new BulkIndexByScrollResponseContentListener(channel, params));
            return;
        }
        ((AbstractBulkByScrollRequest)((Object)internal)).setShouldStoreResult(true);
        ActionRequestValidationException validationException = ((AbstractBulkByScrollRequest)((Object)internal)).validate();
        if (validationException != null) {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)validationException));
            return;
        }
        this.sendTask(channel, client.executeLocally(this.action, internal, LoggingTaskListener.instance()));
    }

    protected abstract Request buildRequest(RestRequest var1) throws IOException;

    protected Request setCommonOptions(RestRequest restRequest, Request request) {
        Float requestsPerSecond;
        assert (restRequest != null) : "RestRequest should not be null";
        assert (request != null) : "Request should not be null";
        ((AbstractBulkByScrollRequest)((Object)request)).setRefresh(restRequest.paramAsBoolean("refresh", ((AbstractBulkByScrollRequest)((Object)request)).isRefresh()));
        ((AbstractBulkByScrollRequest)((Object)request)).setTimeout(restRequest.paramAsTime("timeout", ((AbstractBulkByScrollRequest)((Object)request)).getTimeout()));
        String waitForActiveShards = restRequest.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            ((AbstractBulkByScrollRequest)((Object)request)).setWaitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        if ((requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(restRequest)) != null) {
            ((AbstractBulkByScrollRequest)((Object)request)).setRequestsPerSecond(requestsPerSecond.floatValue());
        }
        return request;
    }

    private void sendTask(RestChannel channel, Task task) throws IOException {
        try (XContentBuilder builder = channel.newBuilder();){
            builder.startObject();
            builder.field("task", this.clusterService.localNode().getId() + ":" + task.getId());
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
        }
    }

    public static Float parseRequestsPerSecond(RestRequest request) {
        float requestsPerSecond;
        String requestsPerSecondString = request.param("requests_per_second");
        if (requestsPerSecondString == null) {
            return null;
        }
        try {
            requestsPerSecond = Float.parseFloat(requestsPerSecondString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.", e);
        }
        if (requestsPerSecond == -1.0f) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.");
        }
        return Float.valueOf(requestsPerSecond);
    }
}

