/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkIndexByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkIndexByScrollResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super(settings, "indices:data/write/update/byquery", threadPool, transportService, actionFilters, indexNameExpressionResolver, UpdateByQueryRequest::new);
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        ClusterState state = this.clusterService.state();
        ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
        new AsyncIndexBySearchAction((BulkByScrollTask)task, this.logger, client, this.threadPool, request, listener, this.scriptService, state).start();
    }

    protected void doExecute(UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkIndexByScrollAction<UpdateByQueryRequest> {
        public AsyncIndexBySearchAction(BulkByScrollTask task, ESLogger logger, ParentTaskAssigningClient client, ThreadPool threadPool, UpdateByQueryRequest request, ActionListener<BulkIndexByScrollResponse> listener, ScriptService scriptService, ClusterState clusterState) {
            super(task, logger, client, threadPool, request, listener, scriptService, clusterState);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return true;
        }

        @Override
        protected BiFunction<AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this.task, this.scriptService, script, (Map<String, Object>)script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkIndexByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.type(doc.getType());
            index.id(doc.getId());
            index.source(doc.getSource());
            index.versionType(VersionType.INTERNAL);
            index.version(doc.getVersion());
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkIndexByScrollAction.ScriptApplier {
            UpdateByQueryScriptApplier(BulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(task, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_index] not allowed");
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_type] not allowed");
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_id] not allowed");
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_version] not allowed");
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_routing] not allowed");
            }

            @Override
            protected void scriptChangedParent(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_parent] not allowed");
            }

            @Override
            protected void scriptChangedTimestamp(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_timestamp] not allowed");
            }

            @Override
            protected void scriptChangedTTL(AbstractAsyncBulkIndexByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_ttl] not allowed");
            }
        }
    }
}

