/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.FieldNameAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.PercolatorFieldMapper;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    public static final String NAME = "percolate";
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private final String documentType;
    private final BytesReference document;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    private final String indexedDocumentType;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document) {
        this(field, documentType, document, XContentFactory.xContentType((BytesReference)document));
    }

    public PercolateQueryBuilder(String field, String documentType, BytesReference document, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documentType == null) {
            throw new IllegalArgumentException("[document_type] is a required argument");
        }
        if (document == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.document = document;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    public PercolateQueryBuilder(String field, String documentType, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documentType == null) {
            throw new IllegalArgumentException("[document_type] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentType == null) {
            throw new IllegalArgumentException("[type] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentType = indexedDocumentType;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.document = null;
        this.documentXContentType = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.documentType = in.readString();
        this.indexedDocumentIndex = in.readOptionalString();
        this.indexedDocumentType = in.readOptionalString();
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        this.document = in.readOptionalBytesReference();
        this.documentXContentType = this.document != null ? (in.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED) ? XContentType.readFrom((StreamInput)in) : XContentFactory.xContentType((BytesReference)this.document)) : null;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.documentType);
        out.writeOptionalString(this.indexedDocumentIndex);
        out.writeOptionalString(this.indexedDocumentType);
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBytesReference(this.document);
        if (this.document != null && out.getVersion().onOrAfter(Version.V_5_3_0_UNRELEASED)) {
            this.documentXContentType.writeTo(out);
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(DOCUMENT_TYPE_FIELD.getPreferredName(), this.documentType);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.document != null) {
            builder.rawField(DOCUMENT_FIELD.getPreferredName(), this.document);
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentType != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), this.indexedDocumentType);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static PercolateQueryBuilder fromXContent(QueryParseContext parseContext) throws IOException {
        PercolateQueryBuilder queryBuilder;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String field = null;
        String documentType = null;
        String indexedDocumentIndex = null;
        String indexedDocumentType = null;
        String indexedDocumentId = null;
        String indexedDocumentRouting = null;
        String indexedDocumentPreference = null;
        Long indexedDocumentVersion = null;
        BytesReference source = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (DOCUMENT_FIELD.match(currentFieldName)) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    Throwable throwable = null;
                    try {
                        builder.copyCurrentStructure(parser);
                        builder.flush();
                        source = builder.bytes();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (builder == null) continue;
                        if (throwable != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        builder.close();
                        continue;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if (DOCUMENT_TYPE_FIELD.match(currentFieldName)) {
                    documentType = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_INDEX.match(currentFieldName)) {
                    indexedDocumentIndex = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_TYPE.match(currentFieldName)) {
                    indexedDocumentType = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ID.match(currentFieldName)) {
                    indexedDocumentId = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_ROUTING.match(currentFieldName)) {
                    indexedDocumentRouting = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_PREFERENCE.match(currentFieldName)) {
                    indexedDocumentPreference = parser.text();
                    continue;
                }
                if (INDEXED_DOCUMENT_FIELD_VERSION.match(currentFieldName)) {
                    indexedDocumentVersion = parser.longValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[percolate] query does not support [" + token + "]", new Object[0]);
        }
        if (documentType == null) {
            throw new IllegalArgumentException("[percolate] query is missing required [" + DOCUMENT_TYPE_FIELD.getPreferredName() + "] parameter");
        }
        if (source != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, source, XContentType.JSON);
        } else if (indexedDocumentId != null) {
            queryBuilder = new PercolateQueryBuilder(field, documentType, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
        } else {
            throw new IllegalArgumentException("[percolate] query, nothing to percolate");
        }
        queryBuilder.queryName(queryName);
        queryBuilder.boost(boost);
        return queryBuilder;
    }

    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.document, other.document) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.indexedDocumentType, other.indexedDocumentType) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documentType, this.document, this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        GetResponse getResponse;
        if (this.document != null) {
            return this;
        }
        GetRequest getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        if (!(getResponse = (GetResponse)queryShardContext.getClient().get(getRequest).actionGet()).isExists()) {
            throw new ResourceNotFoundException("indexed document [{}/{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId});
        }
        if (getResponse.isSourceEmpty()) {
            throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + "/" + this.indexedDocumentType + "/" + this.indexedDocumentId + "] source disabled");
        }
        BytesReference source = getResponse.getSourceAsBytesRef();
        return new PercolateQueryBuilder(this.field, this.documentType, source, XContentFactory.xContentType((BytesReference)source));
    }

    protected Query doToQuery(final QueryShardContext context) throws IOException {
        IndexSearcher docSearcher;
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.document == null) {
            throw new IllegalStateException("no document to percolate");
        }
        MapperService mapperService = context.getMapperService();
        DocumentMapperForType docMapperForType = mapperService.documentMapperWithAutoCreate(this.documentType);
        DocumentMapper docMapper = docMapperForType.getDocumentMapper();
        ParsedDocument doc = docMapper.parse(SourceToParse.source((String)context.index().getName(), (String)this.documentType, (String)"_temp_id", (BytesReference)this.document, (XContentType)this.documentXContentType));
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = (Analyzer)fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (doc.docs().size() > 1) {
            assert (docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher((Analyzer)analyzer, doc);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)doc.rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
        }
        boolean mapUnmappedFieldsAsString = (Boolean)context.getIndexSettings().getValue(PercolatorFieldMapper.INDEX_MAP_UNMAPPED_FIELDS_AS_STRING_SETTING);
        QueryShardContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.FieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        PercolatorFieldMapper.FieldType pft = (PercolatorFieldMapper.FieldType)fieldType;
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft, percolateShardContext, mapUnmappedFieldsAsString);
        return pft.percolateQuery(this.documentType, queryStore, this.document, docSearcher);
    }

    public String getField() {
        return this.field;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public BytesReference getDocument() {
        return this.document;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, ParsedDocument doc) {
        RAMDirectory ramDirectory = new RAMDirectory();
        try (IndexWriter indexWriter = new IndexWriter((Directory)ramDirectory, new IndexWriterConfig(analyzer));){
            indexWriter.addDocuments((Iterable)doc.docs());
            indexWriter.commit();
            DirectoryReader directoryReader = DirectoryReader.open((Directory)ramDirectory);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader){

                public Weight createNormalizedWeight(Query query, boolean needsScores) throws IOException {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    bq.add(query, BooleanClause.Occur.MUST);
                    bq.add(Queries.newNestedFilter(), BooleanClause.Occur.MUST_NOT);
                    return super.createNormalizedWeight((Query)bq.build(), needsScores);
                }
            };
            slowSearcher.setQueryCache(null);
            IndexSearcher indexSearcher = slowSearcher;
            return indexSearcher;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
        }
    }

    private static PercolateQuery.QueryStore createStore(PercolatorFieldMapper.FieldType fieldType, QueryShardContext context, boolean mapUnmappedFieldsAsString) {
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(fieldType.queryBuilderField.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    if (qbSource.length > 0) {
                        XContent xContent = PercolatorFieldMapper.QUERY_BUILDER_CONTENT_TYPE.xContent();
                        try (XContentParser sourceParser = xContent.createParser(context.getXContentRegistry(), qbSource.bytes, qbSource.offset, qbSource.length);){
                            Query query = PercolatorFieldMapper.parseQuery(context, mapUnmappedFieldsAsString, sourceParser);
                            return query;
                        }
                    }
                    return null;
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createNormalizedWeight(query, false);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder();
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build(shardContext.getIndexSettings(), fieldType, (IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker, shardContext.getMapperService());
            }
        };
    }
}

