/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.join.aggregations.ChildrenToParentAggregator;
import org.elasticsearch.join.aggregations.InternalParent;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class ParentAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.Bytes.WithOrdinals> {
    private final Query parentFilter;
    private final Query childFilter;

    public ParentAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.Bytes.WithOrdinals> config, Query childFilter, Query parentFilter, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new NonCollectingAggregator(this.name, searchContext, parent, pipelineAggregators, metaData){

            public InternalAggregation buildEmptyAggregation() {
                return new InternalParent(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
            }
        };
    }

    protected Aggregator doCreateInternal(ValuesSource.Bytes.WithOrdinals valuesSource, SearchContext searchContext, Aggregator children, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        long maxOrd = valuesSource.globalMaxOrd((IndexSearcher)searchContext.searcher());
        if (collectsFromSingleBucket) {
            return new ChildrenToParentAggregator(this.name, this.factories, searchContext, children, this.childFilter, this.parentFilter, valuesSource, maxOrd, pipelineAggregators, metaData);
        }
        return ParentAggregatorFactory.asMultiBucketAggregator((AggregatorFactory)this, (SearchContext)searchContext, (Aggregator)children);
    }
}

