/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.mustache.CustomMustacheFactory;

public final class MustacheScriptEngine
implements ScriptEngine {
    private static final Logger logger = ESLoggerFactory.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> params) {
        if (!context.instanceClazz.equals(ExecutableScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = this.createMustacheFactory(params);
        FastStringReader reader = new FastStringReader(templateSource);
        Mustache template = factory.compile((Reader)reader, "query-template");
        ExecutableScript.Factory compiled = p -> new MustacheExecutableScript(template, p);
        return context.factoryClazz.cast(compiled);
    }

    private CustomMustacheFactory createMustacheFactory(Map<String, String> params) {
        if (params == null || params.isEmpty() || !params.containsKey("content_type")) {
            return new CustomMustacheFactory();
        }
        return new CustomMustacheFactory(params.get("content_type"));
    }

    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private Mustache template;
        private Map<String, Object> vars;

        MustacheExecutableScript(Mustache template, Map<String, Object> vars) {
            this.template = template;
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object run() {
            StringWriter writer = new StringWriter();
            try {
                SpecialPermission.check();
                AccessController.doPrivileged(() -> {
                    this.template.execute((Writer)writer, this.vars);
                    return null;
                });
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Error running {}", (Object)this.template), (Throwable)e);
                throw new GeneralScriptException("Error running " + this.template, (Throwable)e);
            }
            return writer.toString();
        }
    }
}

