/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.attachment;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.attachment.TikaImpl;

public final class AttachmentProcessor
extends AbstractProcessor {
    public static final String TYPE = "attachment";
    private static final int NUMBER_OF_CHARS_INDEXED = 100000;
    private final String field;
    private final String targetField;
    private final Set<Property> properties;
    private final int indexedChars;

    AttachmentProcessor(String tag, String field, String targetField, Set<Property> properties, int indexedChars) throws IOException {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.properties = properties;
        this.indexedChars = indexedChars;
    }

    public void execute(IngestDocument ingestDocument) {
        HashMap<String, String> additionalFields = new HashMap<String, String>();
        try {
            String contentType;
            String keywords;
            String author;
            String title;
            String createdDate;
            Metadata metadata = new Metadata();
            byte[] input = ingestDocument.getFieldValueAsBytes(this.field);
            String parsedContent = TikaImpl.parse(input, metadata, this.indexedChars);
            if (this.properties.contains((Object)Property.CONTENT) && Strings.hasLength((String)parsedContent)) {
                additionalFields.put(Property.CONTENT.toLowerCase(), parsedContent.trim());
            }
            if (this.properties.contains((Object)Property.LANGUAGE) && Strings.hasLength((String)parsedContent)) {
                LanguageIdentifier identifier = new LanguageIdentifier(parsedContent);
                String language = identifier.getLanguage();
                additionalFields.put(Property.LANGUAGE.toLowerCase(), language);
            }
            if (this.properties.contains((Object)Property.DATE) && (createdDate = metadata.get(TikaCoreProperties.CREATED)) != null) {
                additionalFields.put(Property.DATE.toLowerCase(), createdDate);
            }
            if (this.properties.contains((Object)Property.TITLE) && Strings.hasLength((String)(title = metadata.get(TikaCoreProperties.TITLE)))) {
                additionalFields.put(Property.TITLE.toLowerCase(), title);
            }
            if (this.properties.contains((Object)Property.AUTHOR) && Strings.hasLength((String)(author = metadata.get("Author")))) {
                additionalFields.put(Property.AUTHOR.toLowerCase(), author);
            }
            if (this.properties.contains((Object)Property.KEYWORDS) && Strings.hasLength((String)(keywords = metadata.get("Keywords")))) {
                additionalFields.put(Property.KEYWORDS.toLowerCase(), keywords);
            }
            if (this.properties.contains((Object)Property.CONTENT_TYPE) && Strings.hasLength((String)(contentType = metadata.get("Content-Type")))) {
                additionalFields.put(Property.CONTENT_TYPE.toLowerCase(), contentType);
            }
            if (this.properties.contains((Object)Property.CONTENT_LENGTH)) {
                String contentLength = metadata.get("Content-Length");
                String length = Strings.hasLength((String)contentLength) ? contentLength : String.valueOf(parsedContent.length());
                additionalFields.put(Property.CONTENT_LENGTH.toLowerCase(), length);
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Error parsing document in field [{}]", (Throwable)e, new Object[]{this.field});
        }
        ingestDocument.setFieldValue(this.targetField, additionalFields);
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    int getIndexedChars() {
        return this.indexedChars;
    }

    static enum Property {
        CONTENT,
        TITLE,
        AUTHOR,
        KEYWORDS,
        DATE,
        CONTENT_TYPE,
        CONTENT_LENGTH,
        LANGUAGE;


        public static Property parse(String value) {
            return Property.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toLowerCase() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_PROPERTIES = EnumSet.allOf(Property.class);

        public AttachmentProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            Set<Property> properties;
            String field = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)AttachmentProcessor.TYPE);
            List properyNames = ConfigurationUtils.readOptionalList((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"properties");
            int indexedChars = ConfigurationUtils.readIntProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"indexed_chars", (int)100000);
            if (properyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String fieldName : properyNames) {
                    try {
                        properties.add(Property.parse(fieldName));
                    }
                    catch (Exception e) {
                        throw ConfigurationUtils.newConfigurationException((String)AttachmentProcessor.TYPE, (String)processorTag, (String)"properties", (String)("illegal field option [" + fieldName + "]. valid values are " + Arrays.toString((Object[])Property.values())));
                    }
                }
            } else {
                properties = DEFAULT_PROPERTIES;
            }
            return new AttachmentProcessor(processorTag, field, targetField, properties, indexedChars);
        }
    }
}

