/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis.pl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pl.PolishAnalyzer;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.egothor.stemmer.Trie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class PolishStemTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final StempelStemmer stemmer;

    public PolishStemTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        Trie tire;
        try {
            tire = StempelStemmer.load((InputStream)PolishAnalyzer.class.getResourceAsStream("stemmer_20000.tbl"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load default stemming tables", ex);
        }
        this.stemmer = new StempelStemmer(tire);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new StempelFilter(tokenStream, this.stemmer);
    }
}

