/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class KuromojiKatakanaStemmerFactory
extends AbstractTokenFilterFactory {
    private final int minimumLength;

    @Inject
    public KuromojiKatakanaStemmerFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.minimumLength = settings.getAsInt("minimum_length", Integer.valueOf(4));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseKatakanaStemFilter(tokenStream, this.minimumLength);
    }
}

