/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.KuromojiTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class KuromojiAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JapaneseAnalyzer> {
    private final JapaneseAnalyzer analyzer;

    @Inject
    public KuromojiAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)JapaneseAnalyzer.getDefaultStopSet());
        JapaneseTokenizer.Mode mode = KuromojiTokenizerFactory.getMode(settings);
        UserDictionary userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.analyzer = new JapaneseAnalyzer(userDictionary, mode, CharArraySet.copy((Set)stopWords), JapaneseAnalyzer.getDefaultStopTags());
    }

    public JapaneseAnalyzer get() {
        return this.analyzer;
    }
}

