/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Normalizer2;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;

public class IcuNormalizerTokenFilterFactory
extends AbstractTokenFilterFactory
implements MultiTermAwareComponent {
    private final String name;

    public IcuNormalizerTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.name = settings.get("name", "nfkc_cf");
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUNormalizer2Filter(tokenStream, Normalizer2.getInstance(null, (String)this.name, (Normalizer2.Mode)Normalizer2.Mode.COMPOSE));
    }

    public Object getMultiTermComponent() {
        return this;
    }
}

