/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Normalizer2;
import java.io.Reader;
import org.apache.lucene.analysis.icu.ICUNormalizer2CharFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;

public class IcuNormalizerCharFilterFactory
extends AbstractCharFilterFactory
implements MultiTermAwareComponent {
    private final String name;
    private final Normalizer2 normalizer;

    public IcuNormalizerCharFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name);
        this.name = settings.get("name", "nfkc_cf");
        String mode = settings.get("mode");
        if (!"compose".equals(mode) && !"decompose".equals(mode)) {
            mode = "compose";
        }
        this.normalizer = Normalizer2.getInstance(null, (String)this.name, (Normalizer2.Mode)("compose".equals(mode) ? Normalizer2.Mode.COMPOSE : Normalizer2.Mode.DECOMPOSE));
    }

    public Reader create(Reader reader) {
        return new ICUNormalizer2CharFilter(reader, this.normalizer);
    }

    public Object getMultiTermComponent() {
        return this;
    }
}

