/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import java.io.InputStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;

public class IcuFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements MultiTermAwareComponent {
    private final String unicodeSetFilter;

    public IcuFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.unicodeSetFilter = settings.get("unicodeSetFilter");
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.unicodeSetFilter != null) {
            Normalizer2 base = Normalizer2.getInstance((InputStream)ICUFoldingFilter.class.getResourceAsStream("utr30.nrm"), (String)"utr30", (Normalizer2.Mode)Normalizer2.Mode.COMPOSE);
            UnicodeSet unicodeSet = new UnicodeSet(this.unicodeSetFilter);
            unicodeSet.freeze();
            FilteredNormalizer2 filtered = new FilteredNormalizer2(base, unicodeSet);
            return new ICUNormalizer2Filter(tokenStream, (Normalizer2)filtered);
        }
        return new ICUFoldingFilter(tokenStream);
    }

    public Object getMultiTermComponent() {
        return this;
    }
}

