/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.matrix.ArrayValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class ArrayValuesSourceAggregationBuilder<AB extends ArrayValuesSourceAggregationBuilder<AB>>
extends AbstractAggregationBuilder<AB> {
    public static final ParseField MULTIVALUE_MODE_FIELD = new ParseField("mode", new String[0]);
    private List<String> fields = Collections.emptyList();
    private ValueType userValueTypeHint = null;
    private String format = null;
    private Object missing = null;
    private Map<String, Object> missingMap = Collections.emptyMap();

    protected ArrayValuesSourceAggregationBuilder(String name) {
        super(name);
    }

    protected ArrayValuesSourceAggregationBuilder(ArrayValuesSourceAggregationBuilder<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.fields = new ArrayList<String>(clone.fields);
        this.userValueTypeHint = clone.userValueTypeHint;
        this.format = clone.format;
        this.missingMap = new HashMap<String, Object>(clone.missingMap);
        this.missing = clone.missing;
    }

    protected ArrayValuesSourceAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = (ArrayList)in.readGenericValue();
        this.userValueTypeHint = (ValueType)in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
        this.missingMap = in.readMap();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.fields);
        out.writeOptionalWriteable((Writeable)this.userValueTypeHint);
        out.writeOptionalString(this.format);
        out.writeMap(this.missingMap);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    public AB fields(List<String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("[field] must not be null: [" + this.name + "]");
        }
        this.fields = fields;
        return (AB)((Object)this);
    }

    public List<String> fields() {
        return this.fields;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)((Object)this);
    }

    public String format() {
        return this.format;
    }

    public AB missingMap(Map<String, Object> missingMap) {
        if (missingMap == null) {
            throw new IllegalArgumentException("[missing] must not be null: [" + this.name + "]");
        }
        this.missingMap = missingMap;
        return (AB)((Object)this);
    }

    public Map<String, Object> missingMap() {
        return this.missingMap;
    }

    protected final ArrayValuesSourceAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Map<String, ValuesSourceConfig> configs = this.resolveConfig(context);
        ArrayValuesSourceAggregatorFactory factory = this.innerBuild(context, configs, parent, subFactoriesBuilder);
        return factory;
    }

    protected Map<String, ValuesSourceConfig> resolveConfig(AggregationContext context) {
        HashMap<String, ValuesSourceConfig> configs = new HashMap<String, ValuesSourceConfig>();
        for (String field : this.fields) {
            ValuesSourceConfig config = ValuesSourceConfig.resolveUnregistered((AggregationContext)context, (ValueType)this.userValueTypeHint, (String)field, null, (Object)this.missingMap.get(field), null, (String)this.format, (ValuesSourceType)CoreValuesSourceType.KEYWORD);
            configs.put(field, config);
        }
        return configs;
    }

    protected abstract ArrayValuesSourceAggregatorFactory innerBuild(AggregationContext var1, Map<String, ValuesSourceConfig> var2, AggregatorFactory var3, AggregatorFactories.Builder var4) throws IOException;

    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            builder.field(AggregationBuilder.CommonFields.FIELDS.getPreferredName(), this.fields);
        }
        if (this.missing != null) {
            builder.field(AggregationBuilder.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.userValueTypeHint != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.userValueTypeHint.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.format, this.missing, this.userValueTypeHint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrayValuesSourceAggregationBuilder other = (ArrayValuesSourceAggregationBuilder)((Object)obj);
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.format, other.format) && Objects.equals(this.missing, other.missing) && Objects.equals(this.userValueTypeHint, other.userValueTypeHint);
    }

    public static abstract class LeafOnly<AB extends ArrayValuesSourceAggregationBuilder<AB>>
    extends ArrayValuesSourceAggregationBuilder<AB> {
        protected LeafOnly(String name) {
            super(name);
        }

        protected LeafOnly(LeafOnly<AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            super(clone, factoriesBuilder, metadata);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in) throws IOException {
            super(in);
        }

        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }

        public final AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.NONE;
        }
    }
}

