/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.matrix.ArrayValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.matrix.ArrayValuesSourceParser;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStatsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class MatrixStatsParser
extends ArrayValuesSourceParser.NumericValuesSourceParser {
    public MatrixStatsParser() {
        super(true);
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParser parser, Map<ParseField, Object> otherOptions) throws IOException {
        if (ArrayValuesSourceAggregationBuilder.MULTIVALUE_MODE_FIELD.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.VALUE_STRING) {
            otherOptions.put(ArrayValuesSourceAggregationBuilder.MULTIVALUE_MODE_FIELD, parser.text());
            return true;
        }
        return false;
    }

    protected MatrixStatsAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        MatrixStatsAggregationBuilder builder = new MatrixStatsAggregationBuilder(aggregationName);
        String mode = (String)otherOptions.get(ArrayValuesSourceAggregationBuilder.MULTIVALUE_MODE_FIELD);
        if (mode != null) {
            builder.multiValueMode(MultiValueMode.fromString((String)mode));
        }
        return builder;
    }
}

