/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.gradle.FileSystemOperationsAware;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersAware;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.SharedResource;
import org.gradle.util.GradleVersion;

@CacheableTask
public class StandaloneRestIntegTestTask
extends Test
implements TestClustersAware,
FileSystemOperationsAware {
    private Collection<ElasticsearchCluster> clusters = new HashSet<ElasticsearchCluster>();
    private boolean debugServer = false;

    public StandaloneRestIntegTestTask() {
        this.getOutputs().doNotCacheIf("Caching disabled for this task since it uses a cluster shared by other tasks", t -> this.getProject().getTasks().withType(StandaloneRestIntegTestTask.class).stream().filter(task -> task != this).anyMatch(task -> !Collections.disjoint(task.getClusters(), this.getClusters())));
        this.getOutputs().doNotCacheIf("Caching disabled for this task since it is configured to preserve data directory", t -> this.getClusters().stream().anyMatch(cluster -> cluster.isPreserveDataDir()));
    }

    @Option(option="debug-server-jvm", description="Enable debugging configuration, to allow attaching a debugger to elasticsearch.")
    public void setDebugServer(boolean enabled) {
        this.debugServer = enabled;
    }

    public int getMaxParallelForks() {
        return 1;
    }

    @Override
    @Nested
    public Collection<ElasticsearchCluster> getClusters() {
        return this.clusters;
    }

    @Internal
    public List<ResourceLock> getSharedResources() {
        ArrayList<ResourceLock> locks = new ArrayList<ResourceLock>(super.getSharedResources());
        BuildServiceRegistryInternal serviceRegistry = (BuildServiceRegistryInternal)this.getServices().get(BuildServiceRegistryInternal.class);
        Provider throttleProvider = GradleUtils.getBuildService((BuildServiceRegistry)serviceRegistry, "testClustersThrottle");
        SharedResource resource = serviceRegistry.forService(throttleProvider);
        int nodeCount = this.clusters.stream().mapToInt(cluster -> cluster.getNodes().size()).sum();
        if (nodeCount > 0) {
            locks.add(this.getResourceLock(resource, nodeCount));
        }
        return Collections.unmodifiableList(locks);
    }

    private ResourceLock getResourceLock(SharedResource resource, int nodeCount) {
        try {
            Method getResourceLock = Arrays.stream(resource.getClass().getMethods()).filter(p -> p.getName().equals("getResourceLock")).findFirst().get();
            getResourceLock.setAccessible(true);
            return (ResourceLock)(GradleVersion.current().compareTo(GradleVersion.version((String)"7.5.0")) < 0 ? getResourceLock.invoke((Object)resource, Math.min(nodeCount, resource.getMaxUsages())) : getResourceLock.invoke((Object)resource, new Object[0]));
        }
        catch (Exception e) {
            throw new GradleException("Unable to get ResourceLock", (Throwable)e);
        }
    }

    @Override
    public WorkResult delete(Object ... objects) {
        return this.getFileSystemOperations().delete(d -> d.delete(objects));
    }

    @Override
    public void beforeStart() {
        if (this.debugServer) {
            this.enableDebug();
        }
    }
}

