/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.gradle.testclusters.DefaultTestClustersTask;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.ElasticsearchNode;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class RunTask
extends DefaultTestClustersTask {
    private static final Logger logger = Logging.getLogger(RunTask.class);
    public static final String CUSTOM_SETTINGS_PREFIX = "tests.es.";
    private Boolean debug = false;
    private Boolean preserveData = false;
    private Path dataDir = null;
    private String keystorePassword = "";

    @Option(option="debug-jvm", description="Enable debugging configuration, to allow attaching a debugger to elasticsearch.")
    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    @Input
    public Boolean getDebug() {
        return this.debug;
    }

    @Option(option="data-dir", description="Override the base data directory used by the testcluster")
    public void setDataDir(String dataDirStr) {
        this.dataDir = Paths.get(dataDirStr, new String[0]).toAbsolutePath();
    }

    @Input
    public Boolean getPreserveData() {
        return this.preserveData;
    }

    @Option(option="preserve-data", description="Preserves data directory contents (path provided to --data-dir is always preserved)")
    public void setPreserveData(Boolean preserveData) {
        this.preserveData = preserveData;
    }

    @Option(option="keystore-password", description="Set the elasticsearch keystore password")
    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    @Input
    @Optional
    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Input
    @Optional
    public String getDataDir() {
        if (this.dataDir == null) {
            return null;
        }
        return this.dataDir.toString();
    }

    @Override
    public void beforeStart() {
        int httpPort = 9200;
        int transportPort = 9300;
        Map<String, String> additionalSettings = System.getProperties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(CUSTOM_SETTINGS_PREFIX)).collect(Collectors.toMap(entry -> entry.getKey().toString().substring(CUSTOM_SETTINGS_PREFIX.length()), entry -> entry.getValue().toString()));
        boolean singleNode = this.getClusters().stream().flatMap(c -> c.getNodes().stream()).count() == 1L;
        Function<ElasticsearchNode, Path> getDataPath = singleNode ? n -> this.dataDir : n -> this.dataDir.resolve(n.getName());
        for (ElasticsearchCluster cluster : this.getClusters()) {
            cluster.getFirstNode().setHttpPort(String.valueOf(httpPort));
            ++httpPort;
            cluster.getFirstNode().setTransportPort(String.valueOf(transportPort));
            ++transportPort;
            cluster.setPreserveDataDir(this.preserveData);
            for (ElasticsearchNode node : cluster.getNodes()) {
                additionalSettings.forEach(node::setting);
                if (this.dataDir != null) {
                    node.setDataPath(getDataPath.apply(node));
                }
                if (this.keystorePassword.length() <= 0) continue;
                node.keystorePassword(this.keystorePassword);
            }
        }
        if (this.debug.booleanValue()) {
            this.enableDebug();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void runAndWait() throws IOException {
        ArrayList<BufferedReader> toRead = new ArrayList<BufferedReader>();
        ArrayList<BooleanSupplier> aliveChecks = new ArrayList<BooleanSupplier>();
        if (this.getClusters().isEmpty()) {
            throw new GradleException("Task " + this.getPath() + " is not configured to use any clusters. Be sure to call useCluster().");
        }
        try {
            for (ElasticsearchCluster elasticsearchCluster : this.getClusters()) {
                for (Object node : elasticsearchCluster.getNodes()) {
                    BufferedReader reader = Files.newBufferedReader(((ElasticsearchNode)node).getEsOutputFile());
                    toRead.add(reader);
                    aliveChecks.add(((ElasticsearchNode)node)::isProcessAlive);
                }
            }
            while (!Thread.currentThread().isInterrupted()) {
                boolean readData = false;
                for (BufferedReader bufferedReader : toRead) {
                    if (!bufferedReader.ready()) continue;
                    readData = true;
                    logger.lifecycle(bufferedReader.readLine());
                }
                if (!aliveChecks.stream().allMatch(BooleanSupplier::getAsBoolean)) {
                    throw new GradleException("Elasticsearch cluster died");
                }
                if (readData) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Exception thrown = null;
                    for (Closeable closeable : toRead) {
                        try {
                            closeable.close();
                        }
                        catch (Exception e) {
                            if (thrown == null) {
                                thrown = e;
                                continue;
                            }
                            thrown.addSuppressed(e);
                        }
                    }
                    if (thrown != null) {
                        logger.debug("exception occurred during close of stdout file readers", thrown);
                    }
                    return;
                }
            }
        }
        finally {
            Exception thrown = null;
            for (Closeable closeable : toRead) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (thrown == null) {
                        thrown = e;
                        continue;
                    }
                    thrown.addSuppressed(e);
                }
            }
            if (thrown != null) {
                logger.debug("exception occurred during close of stdout file readers", thrown);
            }
        }
    }
}

