/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.plugin;

import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.dependencies.CompileOnlyResolvePlugin;
import org.elasticsearch.gradle.jarhell.JarHellPlugin;
import org.elasticsearch.gradle.plugin.GeneratePluginPropertiesTask;
import org.elasticsearch.gradle.plugin.PluginPropertiesExtension;
import org.elasticsearch.gradle.test.GradleTestPolicySetupPlugin;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.RunTask;
import org.elasticsearch.gradle.testclusters.TestClustersPlugin;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class PluginBuildPlugin
implements Plugin<Project> {
    public static final String PLUGIN_EXTENSION_NAME = "esplugin";
    public static final String BUNDLE_PLUGIN_TASK_NAME = "bundlePlugin";
    public static final String EXPLODED_BUNDLE_PLUGIN_TASK_NAME = "explodedBundlePlugin";
    public static final String EXPLODED_BUNDLE_CONFIG = "explodedBundleZip";
    private final ProviderFactory providerFactory;

    @Inject
    public PluginBuildPlugin(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(TestClustersPlugin.class);
        project.getPluginManager().apply(CompileOnlyResolvePlugin.class);
        project.getPluginManager().apply(JarHellPlugin.class);
        project.getPluginManager().apply(GradleTestPolicySetupPlugin.class);
        PluginPropertiesExtension extension = (PluginPropertiesExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, PluginPropertiesExtension.class, new Object[]{project});
        PluginBuildPlugin.configureDependencies(project);
        TaskProvider<Zip> bundleTask = this.createBundleTasks(project, extension);
        project.getConfigurations().getByName("default").extendsFrom(new Configuration[]{project.getConfigurations().getByName("runtimeClasspath")});
        NamedDomainObjectContainer<ElasticsearchCluster> testClusters = PluginBuildPlugin.testClusters(project, "testClusters");
        NamedDomainObjectProvider runCluster = testClusters.register("runTask", c -> {
            if (GradleUtils.isModuleProject(project.getPath())) {
                c.module((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            } else {
                c.plugin((Provider<RegularFile>)bundleTask.flatMap(zip -> zip.getArchiveFile()));
            }
        });
        project.getTasks().register("run", RunTask.class, r -> {
            r.useCluster((Provider)runCluster);
            r.dependsOn(new Object[]{project.getTasks().named(BUNDLE_PLUGIN_TASK_NAME)});
        });
    }

    private static NamedDomainObjectContainer<ElasticsearchCluster> testClusters(Project project, String extensionName) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(extensionName);
    }

    private static void configureDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("compileOnly", (Object)("org.elasticsearch:elasticsearch:" + VersionProperties.getElasticsearch()));
        dependencies.add("testImplementation", (Object)("org.elasticsearch.test:framework:" + VersionProperties.getElasticsearch()));
    }

    private TaskProvider<Zip> createBundleTasks(Project project, PluginPropertiesExtension extension) {
        File pluginMetadata = project.file((Object)"src/main/plugin-metadata");
        TaskProvider buildProperties = project.getTasks().register("pluginProperties", GeneratePluginPropertiesTask.class, task -> {
            task.getPluginName().set(this.providerFactory.provider(extension::getName));
            task.getPluginDescription().set(this.providerFactory.provider(extension::getDescription));
            task.getPluginVersion().set(this.providerFactory.provider(extension::getVersion));
            task.getElasticsearchVersion().set((Object)Version.fromString(VersionProperties.getElasticsearch()).toString());
            JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            task.getJavaVersion().set(this.providerFactory.provider(() -> javaExtension.getTargetCompatibility().toString()));
            task.getClassname().set(this.providerFactory.provider(extension::getClassname));
            task.getExtendedPlugins().set(this.providerFactory.provider(extension::getExtendedPlugins));
            task.getHasNativeController().set(this.providerFactory.provider(extension::isHasNativeController));
            task.getRequiresKeystore().set(this.providerFactory.provider(extension::isRequiresKeystore));
            task.getPluginType().set(this.providerFactory.provider(extension::getType));
            task.getJavaOpts().set(this.providerFactory.provider(extension::getJavaOpts));
            task.getIsLicensed().set(this.providerFactory.provider(extension::isLicensed));
            SourceSet mainSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main");
            FileTree moduleInfoFile = mainSourceSet.getOutput().getAsFileTree().matching(p -> p.include(new String[]{"module-info.class"}));
            task.getModuleInfoFile().setFrom((Iterable)moduleInfoFile);
        });
        SourceSet testSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test");
        Map<String, TaskProvider> map = Map.of("builtBy", buildProperties);
        testSourceSet.getOutput().dir(map, (Object)new File(project.getBuildDir(), "generated-resources"));
        testSourceSet.getResources().srcDir((Object)pluginMetadata);
        CopySpec bundleSpec = PluginBuildPlugin.createBundleSpec(project, pluginMetadata, (TaskProvider<GeneratePluginPropertiesTask>)buildProperties);
        extension.setBundleSpec(bundleSpec);
        TaskProvider bundle = project.getTasks().register(BUNDLE_PLUGIN_TASK_NAME, Zip.class, zip -> zip.with(new CopySpec[]{bundleSpec}));
        project.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{bundle}));
        Configuration configuration = (Configuration)project.getConfigurations().create("zip");
        configuration.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip");
        project.getArtifacts().add("zip", (Object)bundle);
        TaskProvider explodedBundle = project.getTasks().register(EXPLODED_BUNDLE_PLUGIN_TASK_NAME, Sync.class, sync -> {
            sync.with(new CopySpec[]{bundleSpec});
            sync.into((Object)new File(project.getBuildDir(), "explodedBundle/" + extension.getName()));
        });
        Configuration explodedBundleZip = (Configuration)project.getConfigurations().create(EXPLODED_BUNDLE_CONFIG);
        explodedBundleZip.setCanBeResolved(false);
        explodedBundleZip.setCanBeConsumed(true);
        explodedBundleZip.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        project.getArtifacts().add(EXPLODED_BUNDLE_CONFIG, (Object)explodedBundle);
        return bundle;
    }

    private static CopySpec createBundleSpec(Project project, File pluginMetadata, TaskProvider<GeneratePluginPropertiesTask> buildProperties) {
        CopySpec bundleSpec = project.copySpec();
        bundleSpec.from(new Object[]{buildProperties});
        bundleSpec.from((Object)pluginMetadata, copySpec -> copySpec.exclude(new String[]{"plugin-security.codebases"}));
        bundleSpec.from(new Object[]{() -> project.getPluginManager().hasPlugin("com.github.johnrengelman.shadow") ? project.getTasks().named("shadowJar") : project.getTasks().named("jar")});
        bundleSpec.from(new Object[]{project.getConfigurations().getByName("runtimeClasspath").minus((FileCollection)project.getConfigurations().getByName("resolveableCompileOnly"))});
        bundleSpec.from(new Object[]{"src/main/packaging"});
        bundleSpec.from((Object)"src/main", copySpec -> {
            copySpec.include(new String[]{"config/**"});
            copySpec.include(new String[]{"bin/**"});
        });
        return bundleSpec;
    }
}

