/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.vagrant;

import java.io.File;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;

public class VagrantExtension {
    private final Property<String> box;
    private final MapProperty<String, Object> hostEnv;
    private final MapProperty<String, Object> vmEnv;
    private final RegularFileProperty vagrantfile;
    private boolean isWindowsVM;

    public VagrantExtension(Project project) {
        this.box = project.getObjects().property(String.class);
        this.hostEnv = project.getObjects().mapProperty(String.class, Object.class);
        this.vmEnv = project.getObjects().mapProperty(String.class, Object.class);
        this.vagrantfile = project.getObjects().fileProperty();
        this.vagrantfile.convention(project.getRootProject().getLayout().getProjectDirectory().file("Vagrantfile"));
        this.isWindowsVM = false;
    }

    @Input
    public String getBox() {
        return (String)this.box.get();
    }

    public void setBox(String box) {
        this.box.set((Object)box);
    }

    @Input
    public Map<String, Object> getHostEnv() {
        return (Map)this.hostEnv.get();
    }

    public void hostEnv(String name, Object value) {
        this.hostEnv.put((Object)name, value);
    }

    @Input
    public Map<String, Object> getVmEnv() {
        return (Map)this.vmEnv.get();
    }

    public void vmEnv(String name, Object value) {
        this.vmEnv.put((Object)name, value);
    }

    @Input
    public boolean isWindowsVM() {
        return this.isWindowsVM;
    }

    public void setIsWindowsVM(boolean isWindowsVM) {
        this.isWindowsVM = isWindowsVM;
    }

    @Input
    public File getVagrantfile() {
        return ((RegularFile)this.vagrantfile.get()).getAsFile();
    }

    public void setVagrantfile(File file) {
        this.vagrantfile.set(file);
    }
}

