/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testfixtures;

import com.avast.gradle.dockercompose.ComposeExtension;
import com.avast.gradle.dockercompose.DockerComposePlugin;
import com.avast.gradle.dockercompose.ServiceInfo;
import com.avast.gradle.dockercompose.tasks.ComposeDown;
import com.avast.gradle.dockercompose.tasks.ComposePull;
import com.avast.gradle.dockercompose.tasks.ComposeUp;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.elasticsearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.elasticsearch.gradle.docker.DockerSupportPlugin;
import org.elasticsearch.gradle.docker.DockerSupportService;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.precommit.TestingConventionsTasks;
import org.elasticsearch.gradle.testfixtures.DockerComposeThrottle;
import org.elasticsearch.gradle.testfixtures.TestFixtureExtension;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class TestFixturesPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(TestFixturesPlugin.class);
    private static final String DOCKER_COMPOSE_THROTTLE = "dockerComposeThrottle";
    static final String DOCKER_COMPOSE_YML = "docker-compose.yml";

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        TaskContainer tasks = project.getTasks();
        TestFixtureExtension extension = (TestFixtureExtension)project.getExtensions().create("testFixtures", TestFixtureExtension.class, new Object[]{project});
        Provider dockerComposeThrottle = project.getGradle().getSharedServices().registerIfAbsent(DOCKER_COMPOSE_THROTTLE, DockerComposeThrottle.class, spec -> spec.getMaxParallelUsages().set((Object)1));
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        ExtraPropertiesExtension ext = (ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class);
        File testfixturesDir = project.file((Object)"testfixtures_shared");
        ext.set("testFixturesDir", (Object)testfixturesDir);
        if (project.file((Object)DOCKER_COMPOSE_YML).exists()) {
            project.getPluginManager().apply(BasePlugin.class);
            project.getPluginManager().apply(DockerComposePlugin.class);
            TaskProvider preProcessFixture = project.getTasks().register("preProcessFixture", t -> {
                t.getOutputs().dir((Object)testfixturesDir);
                t.doFirst(t2 -> {
                    try {
                        Files.createDirectories(testfixturesDir.toPath(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            });
            TaskProvider buildFixture = project.getTasks().register("buildFixture", t -> t.dependsOn(new Object[]{preProcessFixture, tasks.named("composeUp")}));
            TaskProvider postProcessFixture = project.getTasks().register("postProcessFixture", task -> {
                task.dependsOn(new Object[]{buildFixture});
                this.configureServiceInfoForTask((Task)task, project, false, (name, port) -> ((ExtraPropertiesExtension)task.getExtensions().getByType(ExtraPropertiesExtension.class)).set(name, port));
            });
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)preProcessFixture);
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)postProcessFixture);
            this.maybeSkipTask(dockerSupport, (TaskProvider<Task>)buildFixture);
            ComposeExtension composeExtension = (ComposeExtension)project.getExtensions().getByType(ComposeExtension.class);
            composeExtension.setUseComposeFiles(Collections.singletonList(DOCKER_COMPOSE_YML));
            composeExtension.setRemoveContainers(true);
            composeExtension.setExecutable(project.file((Object)"/usr/local/bin/docker-compose").exists() ? "/usr/local/bin/docker-compose" : "/usr/bin/docker-compose");
            tasks.named("composeUp").configure(t -> {
                if (BuildParams.isCi().booleanValue()) {
                    t.usesService(dockerComposeThrottle);
                }
                t.mustRunAfter(new Object[]{preProcessFixture});
            });
            tasks.named("composePull").configure(t -> t.mustRunAfter(new Object[]{preProcessFixture}));
            tasks.named("composeDown").configure(t -> t.doLast(t2 -> project.delete(new Object[]{testfixturesDir})));
        } else {
            project.afterEvaluate(spec -> {
                if (extension.fixtures.isEmpty()) {
                    throw new IllegalStateException("No docker-compose.yml found for " + project.getPath() + " nor does it use other fixtures.");
                }
            });
        }
        extension.fixtures.matching(fixtureProject -> !fixtureProject.equals(project)).all(fixtureProject -> project.evaluationDependsOn(fixtureProject.getPath()));
        this.maybeSkipTasks(tasks, dockerSupport, Test.class);
        this.maybeSkipTasks(tasks, dockerSupport, this.getTaskClass("org.elasticsearch.gradle.test.RestIntegTestTask"));
        this.maybeSkipTasks(tasks, dockerSupport, TestingConventionsTasks.class);
        this.maybeSkipTasks(tasks, dockerSupport, this.getTaskClass("org.elasticsearch.gradle.test.AntFixture"));
        this.maybeSkipTasks(tasks, dockerSupport, ComposeUp.class);
        this.maybeSkipTasks(tasks, dockerSupport, ComposePull.class);
        this.maybeSkipTasks(tasks, dockerSupport, ComposeDown.class);
        tasks.withType(Test.class).configureEach(task -> extension.fixtures.all(fixtureProject -> {
            task.dependsOn(new Object[]{fixtureProject.getTasks().named("postProcessFixture")});
            task.finalizedBy(new Object[]{fixtureProject.getTasks().named("composeDown")});
            this.configureServiceInfoForTask((Task)task, (Project)fixtureProject, true, (name, host) -> ((SystemPropertyCommandLineArgumentProvider)task.getExtensions().getByType(SystemPropertyCommandLineArgumentProvider.class)).systemProperty((String)name, host));
        }));
    }

    private void maybeSkipTasks(TaskContainer tasks, Provider<DockerSupportService> dockerSupport, Class<? extends DefaultTask> taskClass) {
        tasks.withType(taskClass).configureEach(t -> this.maybeSkipTask(dockerSupport, (Task)t));
    }

    private void maybeSkipTask(Provider<DockerSupportService> dockerSupport, TaskProvider<Task> task) {
        task.configure(t -> this.maybeSkipTask(dockerSupport, (Task)t));
    }

    private void maybeSkipTask(Provider<DockerSupportService> dockerSupport, Task task) {
        task.onlyIf(spec -> {
            boolean isComposeAvailable = ((DockerSupportService)dockerSupport.get()).getDockerAvailability().isComposeAvailable;
            if (!isComposeAvailable) {
                LOGGER.info("Task {} requires docker-compose but it is unavailable. Task will be skipped.", (Object)task.getPath());
            }
            return isComposeAvailable;
        });
    }

    private void configureServiceInfoForTask(Task task, final Project fixtureProject, final boolean enableFilter, final BiConsumer<String, Integer> consumer) {
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task theTask) {
                TestFixtureExtension extension = (TestFixtureExtension)theTask.getProject().getExtensions().getByType(TestFixtureExtension.class);
                ((ComposeExtension)fixtureProject.getExtensions().getByType(ComposeExtension.class)).getServicesInfos().entrySet().stream().filter(entry -> !enableFilter || extension.isServiceRequired((String)entry.getKey(), fixtureProject.getPath())).forEach(entry -> {
                    String service = (String)entry.getKey();
                    ServiceInfo infos = (ServiceInfo)entry.getValue();
                    infos.getTcpPorts().forEach((container, host) -> {
                        String name = "test.fixtures." + service + ".tcp." + container;
                        theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                        consumer.accept(name, host);
                    });
                    infos.getUdpPorts().forEach((container, host) -> {
                        String name = "test.fixtures." + service + ".udp." + container;
                        theTask.getLogger().info("port mapping property: {}={}", (Object)name, host);
                        consumer.accept(name, host);
                    });
                });
            }
        });
    }

    private Class<? extends DefaultTask> getTaskClass(String type) {
        Class<?> aClass;
        try {
            aClass = Class.forName(type);
            if (!DefaultTask.class.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException("Not a task type: " + type);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such task: " + type);
        }
        return aClass;
    }
}

