/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.FileSupplier;
import org.elasticsearch.gradle.Jdk;
import org.elasticsearch.gradle.LazyPropertyList;
import org.elasticsearch.gradle.LazyPropertyMap;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.PropertyNormalization;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.http.WaitForHttpResource;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.testclusters.TestClusterConfiguration;
import org.elasticsearch.gradle.testclusters.TestClustersException;
import org.elasticsearch.gradle.testclusters.TestDistribution;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.process.ExecSpec;

public class ElasticsearchNode
implements TestClusterConfiguration {
    private static final Logger LOGGER = Logging.getLogger(ElasticsearchNode.class);
    private static final int ES_DESTROY_TIMEOUT = 20;
    private static final TimeUnit ES_DESTROY_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final int NODE_UP_TIMEOUT = 2;
    private static final TimeUnit NODE_UP_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int ADDITIONAL_CONFIG_TIMEOUT = 15;
    private static final TimeUnit ADDITIONAL_CONFIG_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final List<String> OVERRIDABLE_SETTINGS = Arrays.asList("path.repo", "discovery.seed_providers");
    private static final int TAIL_LOG_MESSAGES_COUNT = 40;
    private static final List<String> MESSAGES_WE_DONT_CARE_ABOUT = Arrays.asList("Option UseConcMarkSweepGC was deprecated", "is a pre-release version of Elasticsearch", "max virtual memory areas vm.max_map_count");
    private static final String HOSTNAME_OVERRIDE = "LinuxDarwinHostname";
    private static final String COMPUTERNAME_OVERRIDE = "WindowsComputername";
    private final String path;
    private final String name;
    private final Project project;
    private final ReaperService reaper;
    private final Jdk bwcJdk;
    private final AtomicBoolean configurationFrozen = new AtomicBoolean(false);
    private final Path workingDir;
    private final LinkedHashMap<String, Predicate<TestClusterConfiguration>> waitConditions = new LinkedHashMap();
    private final List<Provider<URI>> plugins = new ArrayList<Provider<URI>>();
    private final List<Provider<File>> modules = new ArrayList<Provider<File>>();
    final LazyPropertyMap<String, CharSequence> settings = new LazyPropertyMap("Settings", this);
    private final LazyPropertyMap<String, CharSequence> keystoreSettings = new LazyPropertyMap("Keystore", this);
    private final LazyPropertyMap<String, File> keystoreFiles = new LazyPropertyMap<String, File>("Keystore files", this, FileEntry::new);
    private final LazyPropertyList<CliEntry> cliSetup = new LazyPropertyList("CLI setup commands", this);
    private final LazyPropertyMap<String, CharSequence> systemProperties = new LazyPropertyMap("System properties", this);
    private final LazyPropertyMap<String, CharSequence> environment = new LazyPropertyMap("Environment", this);
    private final LazyPropertyList<CharSequence> jvmArgs = new LazyPropertyList("JVM arguments", this);
    private final LazyPropertyMap<String, File> extraConfigFiles = new LazyPropertyMap<String, File>("Extra config files", this, FileEntry::new);
    private final LazyPropertyList<File> extraJarFiles = new LazyPropertyList("Extra jar files", this);
    private final List<Map<String, String>> credentials = new ArrayList<Map<String, String>>();
    final LinkedHashMap<String, String> defaultConfig = new LinkedHashMap();
    private final Path confPathRepo;
    private final Path configFile;
    private final Path confPathLogs;
    private final Path transportPortFile;
    private final Path httpPortsFile;
    private final Path esStdoutFile;
    private final Path esStderrFile;
    private final Path esStdinFile;
    private final Path tmpDir;
    private int currentDistro = 0;
    private TestDistribution testDistribution;
    private List<ElasticsearchDistribution> distributions = new ArrayList<ElasticsearchDistribution>();
    private volatile Process esProcess;
    private Function<String, String> nameCustomization = Function.identity();
    private boolean isWorkingDirConfigured = false;
    private String httpPort = "0";
    private String transportPort = "0";
    private Path confPathData;
    private String keystorePassword = "";

    ElasticsearchNode(String name, Project project, ReaperService reaper, File workingDirBase, Jdk bwcJdk) {
        this.path = project.getPath();
        this.name = name;
        this.project = project;
        this.reaper = reaper;
        this.bwcJdk = bwcJdk;
        this.workingDir = workingDirBase.toPath().resolve(this.safeName(name)).toAbsolutePath();
        this.confPathRepo = this.workingDir.resolve("repo");
        this.configFile = this.workingDir.resolve("config/elasticsearch.yml");
        this.confPathData = this.workingDir.resolve("data");
        this.confPathLogs = this.workingDir.resolve("logs");
        this.transportPortFile = this.confPathLogs.resolve("transport.ports");
        this.httpPortsFile = this.confPathLogs.resolve("http.ports");
        this.esStdoutFile = this.confPathLogs.resolve("es.stdout.log");
        this.esStderrFile = this.confPathLogs.resolve("es.stderr.log");
        this.esStdinFile = this.workingDir.resolve("es.stdin");
        this.tmpDir = this.workingDir.resolve("tmp");
        this.waitConditions.put("ports files", this::checkPortsFilesExistWithDelay);
        this.setTestDistribution(TestDistribution.INTEG_TEST);
        this.setVersion(VersionProperties.getElasticsearch());
    }

    @Input
    @Optional
    public String getName() {
        return this.nameCustomization.apply(this.name);
    }

    @Internal
    public Version getVersion() {
        return Version.fromString(this.distributions.get(this.currentDistro).getVersion());
    }

    @Internal
    public Path getDistroDir() {
        return this.workingDir.resolve("distro").resolve(this.getVersion() + "-" + this.testDistribution);
    }

    @Override
    public void setVersion(String version) {
        Objects.requireNonNull(version, "null version passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.distributions.clear();
        this.doSetVersion(version);
    }

    @Override
    public void setVersions(List<String> versions) {
        Objects.requireNonNull(versions, "null version list passed when configuring test cluster `" + this + "`");
        this.distributions.clear();
        for (String version : versions) {
            this.doSetVersion(version);
        }
    }

    private void doSetVersion(String version) {
        String distroName = "testclusters" + this.path.replace(":", "-") + "-" + this.name + "-" + version + "-";
        NamedDomainObjectContainer<ElasticsearchDistribution> container = DistributionDownloadPlugin.getContainer(this.project);
        if (container.findByName(distroName) == null) {
            container.create(distroName);
        }
        ElasticsearchDistribution distro = (ElasticsearchDistribution)container.getByName(distroName);
        distro.setVersion(version);
        distro.setArchitecture(Architecture.current());
        this.setDistributionType(distro, this.testDistribution);
        this.distributions.add(distro);
    }

    @Internal
    public TestDistribution getTestDistribution() {
        return this.testDistribution;
    }

    @Internal
    List<ElasticsearchDistribution> getDistributions() {
        return this.distributions;
    }

    @Override
    public void setTestDistribution(TestDistribution testDistribution) {
        Objects.requireNonNull(testDistribution, "null distribution passed when configuring test cluster `" + this + "`");
        this.checkFrozen();
        this.testDistribution = testDistribution;
        for (ElasticsearchDistribution distribution : this.distributions) {
            this.setDistributionType(distribution, testDistribution);
        }
    }

    private void setDistributionType(ElasticsearchDistribution distribution, TestDistribution testDistribution) {
        if (testDistribution == TestDistribution.INTEG_TEST) {
            distribution.setType(ElasticsearchDistribution.Type.INTEG_TEST_ZIP);
            distribution.setFlavor(null);
            distribution.setPlatform(null);
            distribution.setBundledJdk(null);
        } else {
            distribution.setType(ElasticsearchDistribution.Type.ARCHIVE);
            if (testDistribution == TestDistribution.DEFAULT) {
                distribution.setFlavor(ElasticsearchDistribution.Flavor.DEFAULT);
            } else {
                distribution.setFlavor(ElasticsearchDistribution.Flavor.OSS);
            }
        }
    }

    @Override
    public void plugin(RegularFileProperty plugin) {
        this.plugins.add((Provider<URI>)plugin.map(p -> p.getAsFile().toURI()));
    }

    @Override
    public void plugin(Provider<URI> plugin) {
        Objects.requireNonNull(plugin, "Plugin name can't be null");
        this.checkFrozen();
        if (this.plugins.contains(plugin)) {
            throw new TestClustersException("Plugin already configured for installation " + plugin);
        }
        this.plugins.add(plugin);
    }

    @Override
    public void plugin(URI plugin) {
        Property uri = this.project.getObjects().property(URI.class);
        uri.set((Object)plugin);
        this.plugin((Provider<URI>)uri);
    }

    @Override
    public void plugin(File plugin) {
        Property uri = this.project.getObjects().property(URI.class);
        uri.set((Object)plugin.toURI());
        this.plugin((Provider<URI>)uri);
    }

    @Override
    public void module(File module) {
        RegularFileProperty file = this.project.getObjects().fileProperty();
        file.fileValue(module);
        this.module((Provider<RegularFile>)file);
    }

    @Override
    public void module(Provider<RegularFile> module) {
        this.modules.add((Provider<File>)module.map(RegularFile::getAsFile));
    }

    @Override
    public void keystore(String key, String value) {
        this.keystoreSettings.put(key, value);
    }

    @Override
    public void keystore(String key, Supplier<CharSequence> valueSupplier) {
        this.keystoreSettings.put(key, valueSupplier);
    }

    @Override
    public void keystore(String key, File value) {
        this.keystoreFiles.put(key, value);
    }

    @Override
    public void keystore(String key, File value, PropertyNormalization normalization) {
        this.keystoreFiles.put(key, value, normalization);
    }

    @Override
    public void keystore(String key, FileSupplier valueSupplier) {
        this.keystoreFiles.put(key, valueSupplier);
    }

    @Override
    public void keystorePassword(String password) {
        this.keystorePassword = password;
    }

    @Override
    public void cliSetup(String binTool, CharSequence ... args) {
        this.cliSetup.add(new CliEntry(binTool, args));
    }

    @Override
    public void setting(String key, String value) {
        this.settings.put(key, value);
    }

    @Override
    public void setting(String key, String value, PropertyNormalization normalization) {
        this.settings.put(key, value, normalization);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier) {
        this.settings.put(key, valueSupplier);
    }

    @Override
    public void setting(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.settings.put(key, valueSupplier, normalization);
    }

    @Override
    public void systemProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier) {
        this.systemProperties.put(key, valueSupplier);
    }

    @Override
    public void systemProperty(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.systemProperties.put(key, valueSupplier, normalization);
    }

    @Override
    public void environment(String key, String value) {
        this.environment.put(key, value);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier) {
        this.environment.put(key, valueSupplier);
    }

    @Override
    public void environment(String key, Supplier<CharSequence> valueSupplier, PropertyNormalization normalization) {
        this.environment.put(key, valueSupplier, normalization);
    }

    @Override
    public void jvmArgs(String ... values) {
        this.jvmArgs.addAll((Collection<CharSequence>)Arrays.asList(values));
    }

    @Internal
    public Path getConfigDir() {
        return this.configFile.getParent();
    }

    @Override
    public void freeze() {
        Objects.requireNonNull(this.testDistribution, "null testDistribution passed when configuring test cluster `" + this + "`");
        LOGGER.info("Locking configuration of `{}`", (Object)this);
        this.configurationFrozen.set(true);
    }

    public Stream<String> logLines() throws IOException {
        return Files.lines(this.esStdoutFile, StandardCharsets.UTF_8);
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Starting `{}`", (Object)this);
        if (!Files.exists(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", missing: " + this.getExtractedDistributionDir());
        }
        if (!Files.isDirectory(this.getExtractedDistributionDir(), new LinkOption[0])) {
            throw new TestClustersException("Can not start " + this + ", is not a directory: " + this.getExtractedDistributionDir());
        }
        try {
            if (!this.isWorkingDirConfigured) {
                this.logToProcessStdout("Configuring working directory: " + this.workingDir);
                if (Files.exists(this.workingDir, new LinkOption[0])) {
                    this.project.delete(new Object[]{this.workingDir});
                }
                this.isWorkingDirConfigured = true;
            }
            this.createWorkingDir(this.getExtractedDistributionDir());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create working directory for " + this, e);
        }
        this.copyExtraJars();
        this.copyExtraConfigFiles();
        this.createConfiguration();
        ArrayList<String> pluginsToInstall = new ArrayList<String>();
        if (!this.plugins.isEmpty()) {
            pluginsToInstall.addAll(this.plugins.stream().map(Provider::get).map(URI::toString).collect(Collectors.toList()));
        }
        if (this.getVersion().before("6.3.0") && this.testDistribution == TestDistribution.DEFAULT) {
            this.logToProcessStdout("emulating the " + this.testDistribution + " flavor for " + this.getVersion() + " by installing x-pack");
            pluginsToInstall.add("x-pack");
        }
        if (!pluginsToInstall.isEmpty()) {
            if (this.getVersion().onOrAfter("7.6.0")) {
                this.logToProcessStdout("installing " + pluginsToInstall.size() + " plugins in a single transaction");
                CharSequence[] arguments = (String[])Stream.concat(Stream.of("install", "--batch"), pluginsToInstall.stream()).toArray(String[]::new);
                this.runElasticsearchBinScript("elasticsearch-plugin", arguments);
                this.logToProcessStdout("installed plugins");
            } else {
                this.logToProcessStdout("installing " + pluginsToInstall.size() + " plugins sequentially");
                pluginsToInstall.forEach(plugin -> this.runElasticsearchBinScript("elasticsearch-plugin", "install", "--batch", (CharSequence)plugin));
                this.logToProcessStdout("installed plugins");
            }
        }
        this.logToProcessStdout("Creating elasticsearch keystore with password set to [" + this.keystorePassword + "]");
        if (this.keystorePassword.length() > 0) {
            this.runElasticsearchBinScriptWithInput(this.keystorePassword + "\n" + this.keystorePassword, "elasticsearch-keystore", "create", "-p");
        } else {
            this.runElasticsearchBinScript("elasticsearch-keystore", "create");
        }
        if (!this.keystoreSettings.isEmpty() || !this.keystoreFiles.isEmpty()) {
            this.logToProcessStdout("Adding " + this.keystoreSettings.size() + " keystore settings and " + this.keystoreFiles.size() + " keystore files");
            this.keystoreSettings.forEach((key, value) -> this.runKeystoreCommandWithPassword(this.keystorePassword, value.toString(), "add", "-x", (CharSequence)key));
            for (Map.Entry<String, File> entry : this.keystoreFiles.entrySet()) {
                File file = entry.getValue();
                Objects.requireNonNull(file, "supplied keystoreFile was null when configuring " + this);
                if (!file.exists()) {
                    throw new TestClustersException("supplied keystore file " + file + " does not exist, require for " + this);
                }
                this.runKeystoreCommandWithPassword(this.keystorePassword, "", "add-file", entry.getKey(), file.getAbsolutePath());
            }
        }
        this.installModules();
        if (this.isSettingTrue("xpack.security.enabled") && this.credentials.isEmpty()) {
            this.user(Collections.emptyMap());
        }
        if (!this.credentials.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.credentials.size() + " users");
            this.credentials.forEach(paramMap -> this.runElasticsearchBinScript(this.getVersion().onOrAfter("6.3.0") ? "elasticsearch-users" : "x-pack/users", (CharSequence[])paramMap.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).toArray(String[]::new)));
        }
        if (!this.cliSetup.isEmpty()) {
            this.logToProcessStdout("Running " + this.cliSetup.size() + " setup commands");
            for (CliEntry cliEntry : this.cliSetup) {
                this.runElasticsearchBinScript(cliEntry.executable, cliEntry.args);
            }
        }
        this.logToProcessStdout("Starting Elasticsearch process");
        this.startElasticsearchProcess();
    }

    private void logToProcessStdout(String message) {
        try {
            if (!Files.exists(this.esStdoutFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.esStdoutFile.getParent(), new FileAttribute[0]);
            }
            Files.write(this.esStdoutFile, ("[" + Instant.now().toString() + "] [BUILD] " + message + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void restart() {
        LOGGER.info("Restarting {}", (Object)this);
        this.stop(false);
        this.start();
    }

    void goToNextVersion() {
        if (this.currentDistro + 1 >= this.distributions.size()) {
            throw new TestClustersException("Ran out of versions to go to for " + this);
        }
        this.logToProcessStdout("Switch version from " + this.getVersion() + " to " + this.distributions.get(this.currentDistro + 1).getVersion());
        ++this.currentDistro;
        this.setting("node.attr.upgraded", "true");
    }

    private boolean isSettingTrue(String name) {
        return Boolean.valueOf(this.settings.getOrDefault(name, "false").toString());
    }

    private void copyExtraConfigFiles() {
        if (!this.extraConfigFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraConfigFiles.size() + " additional config files");
        }
        this.extraConfigFiles.forEach((destination, from) -> {
            if (!Files.exists(from.toPath(), new LinkOption[0])) {
                throw new TestClustersException("Can't create extra config file from " + from + " for " + this + " as it does not exist");
            }
            Path dst = this.configFile.getParent().resolve((String)destination);
            try {
                Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                Files.copy(from.toPath(), dst, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra config file {} for {}", destination, (Object)this);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't create extra config file for", e);
            }
        });
    }

    private void copyExtraJars() {
        if (!this.extraJarFiles.isEmpty()) {
            this.logToProcessStdout("Setting up " + this.extraJarFiles.size() + " additional jar dependencies");
        }
        this.extraJarFiles.forEach(from -> {
            Path destination = this.getDistroDir().resolve("lib").resolve(from.getName());
            try {
                Files.copy(from.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Added extra jar {} to {}", (Object)from.getName(), (Object)destination);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't copy extra jar dependency " + from.getName() + " to " + destination.toString(), e);
            }
        });
    }

    private void installModules() {
        if (this.testDistribution == TestDistribution.INTEG_TEST) {
            this.logToProcessStdout("Installing " + this.modules.size() + "modules");
            for (Provider<File> module : this.modules) {
                Path destination = this.getDistroDir().resolve("modules").resolve(((File)module.get()).getName().replace(".zip", "").replace("-" + this.getVersion(), "").replace("-SNAPSHOT", ""));
                if (Files.exists(destination, new LinkOption[0])) continue;
                this.project.copy(spec -> {
                    if (((File)module.get()).getName().toLowerCase().endsWith(".zip")) {
                        spec.from(new Object[]{this.project.zipTree((Object)module)});
                    } else if (((File)module.get()).isDirectory()) {
                        spec.from(new Object[]{module});
                    } else {
                        throw new IllegalArgumentException("Not a valid module " + module + " for " + this);
                    }
                    spec.into((Object)destination);
                });
            }
        } else {
            LOGGER.info("Not installing " + this.modules.size() + "(s) since the " + this.distributions + " distribution already has them");
        }
    }

    @Override
    public void extraConfigFile(String destination, File from) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from);
    }

    @Override
    public void extraConfigFile(String destination, File from, PropertyNormalization normalization) {
        if (destination.contains("..")) {
            throw new IllegalArgumentException("extra config file destination can't be relative, was " + destination + " for " + this);
        }
        this.extraConfigFiles.put(destination, from, normalization);
    }

    @Override
    public void extraJarFile(File from) {
        if (!from.toString().endsWith(".jar")) {
            throw new IllegalArgumentException("extra jar file " + from.toString() + " doesn't appear to be a JAR");
        }
        this.extraJarFiles.add(from);
    }

    @Override
    public void user(Map<String, String> userSpec) {
        HashSet<String> keys = new HashSet<String>(userSpec.keySet());
        keys.remove("username");
        keys.remove("password");
        keys.remove("role");
        if (!keys.isEmpty()) {
            throw new TestClustersException("Unknown keys in user definition " + keys + " for " + this);
        }
        LinkedHashMap<String, String> cred = new LinkedHashMap<String, String>();
        cred.put("useradd", userSpec.getOrDefault("username", "test_user"));
        cred.put("-p", userSpec.getOrDefault("password", "x-pack-test-password"));
        cred.put("-r", userSpec.getOrDefault("role", "superuser"));
        this.credentials.add(cred);
    }

    private void runElasticsearchBinScriptWithInput(String input, String tool, CharSequence ... args) {
        if (!Files.exists(this.getDistroDir().resolve("bin").resolve(tool), new LinkOption[0]) && !Files.exists(this.getDistroDir().resolve("bin").resolve(tool + ".bat"), new LinkOption[0])) {
            throw new TestClustersException("Can't run bin script: `" + tool + "` does not exist. Is this the distribution you expect it to be ?");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            LoggedExec.exec(this.project, (Action<ExecSpec>)((Action)spec -> {
                spec.setEnvironment(this.getESEnvironment());
                spec.workingDir((Object)this.getDistroDir());
                spec.executable((Object)OS.conditionalString().onUnix(() -> "./bin/" + tool).onWindows(() -> "cmd").supply());
                spec.args((Iterable)OS.conditional().onWindows(() -> {
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.add("/c");
                    result.add("bin\\" + tool + ".bat");
                    for (CharSequence arg : args) {
                        result.add(arg);
                    }
                    return result;
                }).onUnix(() -> Arrays.asList(args)).supply());
                spec.setStandardInput(byteArrayInputStream);
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to run " + tool + " for " + this, e);
        }
    }

    private void runKeystoreCommandWithPassword(String keystorePassword, String input, CharSequence ... args) {
        String actualInput = keystorePassword.length() > 0 ? keystorePassword + "\n" + input : input;
        this.runElasticsearchBinScriptWithInput(actualInput, "elasticsearch-keystore", args);
    }

    private void runElasticsearchBinScript(String tool, CharSequence ... args) {
        this.runElasticsearchBinScriptWithInput("", tool, args);
    }

    private Map<String, String> getESEnvironment() {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        this.getRequiredJavaHome().ifPresent(javaHome -> defaultEnv.put("JAVA_HOME", (String)javaHome));
        defaultEnv.put("ES_PATH_CONF", this.configFile.getParent().toString());
        Object systemPropertiesString = "";
        if (!this.systemProperties.isEmpty()) {
            systemPropertiesString = " " + this.systemProperties.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + entry.getValue()).map(p -> p.replace("${ES_PATH_CONF}", this.configFile.getParent().toString())).collect(Collectors.joining(" "));
        }
        Object jvmArgsString = "";
        if (!this.jvmArgs.isEmpty()) {
            jvmArgsString = " " + this.jvmArgs.stream().peek(argument -> {
                if (argument.toString().startsWith("-D")) {
                    throw new TestClustersException("Invalid jvm argument `" + argument + "` configure as systemProperty instead for " + this);
                }
            }).collect(Collectors.joining(" "));
        }
        String heapSize = System.getProperty("tests.heap.size", "512m");
        defaultEnv.put("ES_JAVA_OPTS", "-Xms" + heapSize + " -Xmx" + heapSize + " -ea -esa " + (String)systemPropertiesString + " " + (String)jvmArgsString + " " + System.getProperty("tests.jvm.argline", ""));
        defaultEnv.put("ES_TMPDIR", this.tmpDir.toString());
        defaultEnv.put("TMP", this.tmpDir.toString());
        defaultEnv.put("HOSTNAME", HOSTNAME_OVERRIDE);
        defaultEnv.put("COMPUTERNAME", COMPUTERNAME_OVERRIDE);
        HashSet<String> commonKeys = new HashSet<String>(this.environment.keySet());
        commonKeys.retainAll(defaultEnv.keySet());
        if (!commonKeys.isEmpty()) {
            throw new IllegalStateException("testcluster does not allow overwriting the following env vars " + commonKeys + " for " + this);
        }
        this.environment.forEach((key, value) -> defaultEnv.put((String)key, value.toString()));
        return defaultEnv;
    }

    private java.util.Optional<String> getRequiredJavaHome() {
        if (this.getTestDistribution() == TestDistribution.INTEG_TEST || this.getVersion().equals(VersionProperties.getElasticsearchVersion())) {
            return java.util.Optional.of(BuildParams.getRuntimeJavaHome()).map(File::getAbsolutePath);
        }
        if (this.getVersion().before("7.0.0")) {
            return java.util.Optional.of(this.bwcJdk.getJavaHomePath().toString());
        }
        return java.util.Optional.empty();
    }

    @Internal
    Jdk getBwcJdk() {
        return this.getVersion().before("7.0.0") ? this.bwcJdk : null;
    }

    private void startElasticsearchProcess() {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List command = OS.conditional().onUnix(() -> Arrays.asList(this.workingDir.relativize(this.getDistroDir()).resolve("./bin/elasticsearch").toString())).onWindows(() -> Arrays.asList("cmd", "/c", this.workingDir.relativize(this.getDistroDir()).resolve("bin\\elasticsearch.bat").toString())).supply();
        processBuilder.command(command);
        processBuilder.directory(this.workingDir.toFile());
        Map<String, String> environment = processBuilder.environment();
        environment.clear();
        environment.putAll(this.getESEnvironment());
        processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(this.esStderrFile.toFile()));
        processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.esStdoutFile.toFile()));
        if (this.keystorePassword != null && this.keystorePassword.length() > 0) {
            try {
                Files.write(this.esStdinFile, (this.keystorePassword + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                processBuilder.redirectInput(this.esStdinFile.toFile());
            }
            catch (IOException e) {
                throw new TestClustersException("Failed to set the keystore password for " + this, e);
            }
        }
        LOGGER.info("Running `{}` in `{}` for {} env: {}", new Object[]{command, this.workingDir, this, environment});
        try {
            this.esProcess = processBuilder.start();
        }
        catch (IOException e) {
            throw new TestClustersException("Failed to start ES process for " + this, e);
        }
        this.reaper.registerPid(this.toString(), this.esProcess.pid());
    }

    @Override
    @Internal
    public String getHttpSocketURI() {
        return this.getHttpPortInternal().get(0);
    }

    @Override
    @Internal
    public String getTransportPortURI() {
        return this.getTransportPortInternal().get(0);
    }

    @Override
    @Internal
    public List<String> getAllHttpSocketURI() {
        this.waitForAllConditions();
        return this.getHttpPortInternal();
    }

    @Override
    @Internal
    public List<String> getAllTransportPortURI() {
        this.waitForAllConditions();
        return this.getTransportPortInternal();
    }

    @Internal
    public File getServerLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_server.json").toFile();
    }

    @Internal
    public File getAuditLog() {
        return this.confPathLogs.resolve(this.defaultConfig.get("cluster.name") + "_audit.json").toFile();
    }

    @Override
    public synchronized void stop(boolean tailLogs) {
        this.logToProcessStdout("Stopping node");
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.esProcess == null && tailLogs) {
            return;
        }
        LOGGER.info("Stopping `{}`, tailLogs: {}", (Object)this, (Object)tailLogs);
        Objects.requireNonNull(this.esProcess, "Can't stop `" + this + "` as it was not started or already stopped.");
        this.stopHandle(this.esProcess.toHandle(), true);
        this.reaper.unregister(this.toString());
        if (tailLogs) {
            this.logFileContents("Standard output of node", this.esStdoutFile);
            this.logFileContents("Standard error of node", this.esStderrFile);
        }
        this.esProcess = null;
        try {
            if (Files.exists(this.httpPortsFile, new LinkOption[0])) {
                Files.delete(this.httpPortsFile);
            }
            if (Files.exists(this.transportPortFile, new LinkOption[0])) {
                Files.delete(this.transportPortFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setNameCustomization(Function<String, String> nameCustomizer) {
        this.nameCustomization = nameCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHandle(ProcessHandle processHandle, boolean forcibly) {
        if (!processHandle.isAlive()) {
            LOGGER.info("Process was not running when we tried to terminate it.");
            return;
        }
        List<ProcessHandle> children = processHandle.children().collect(Collectors.toList());
        try {
            this.logProcessInfo("Terminating elasticsearch process" + (forcibly ? " forcibly " : "gracefully") + ":", processHandle.info());
            if (forcibly) {
                processHandle.destroyForcibly();
            } else {
                processHandle.destroy();
                this.waitForProcessToExit(processHandle);
                if (!processHandle.isAlive()) {
                    return;
                }
                LOGGER.info("process did not terminate after {} {}, stopping it forcefully", (Object)20, (Object)ES_DESTROY_TIMEOUT_UNIT);
                processHandle.destroyForcibly();
            }
            this.waitForProcessToExit(processHandle);
            if (processHandle.isAlive()) {
                throw new TestClustersException("Was not able to terminate elasticsearch process for " + this);
            }
        }
        finally {
            children.forEach(each -> this.stopHandle((ProcessHandle)each, forcibly));
        }
    }

    private void logProcessInfo(String prefix, ProcessHandle.Info info) {
        LOGGER.info(prefix + " commandLine:`{}` command:`{}` args:`{}`", new Object[]{info.commandLine().orElse("-"), info.command().orElse("-"), Arrays.stream(info.arguments().orElse(new String[0])).map(each -> "'" + each + "'").collect(Collectors.joining(" "))});
    }

    private void logFileContents(String description, Path from) {
        LinkedHashMap<String, Integer> errorsAndWarnings = new LinkedHashMap<String, Integer>();
        LinkedList<String> ring = new LinkedList<String>();
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(from));){
            String line2 = reader.readLine();
            while (line2 != null) {
                Object lineToAdd;
                if (ring.isEmpty()) {
                    lineToAdd = line2;
                } else if (line2.startsWith("[")) {
                    lineToAdd = line2;
                    String previousMessage = this.normalizeLogLine((String)ring.getLast());
                    if (MESSAGES_WE_DONT_CARE_ABOUT.stream().noneMatch(previousMessage::contains) && (previousMessage.contains("ERROR") || previousMessage.contains("WARN"))) {
                        errorsAndWarnings.put(previousMessage, errorsAndWarnings.getOrDefault(previousMessage, 0) + 1);
                    }
                } else {
                    lineToAdd = (String)ring.removeLast() + "\n" + line2;
                }
                ring.add((String)lineToAdd);
                if (ring.size() >= 40) {
                    ring.removeFirst();
                }
                line2 = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to tail log " + this, e);
        }
        if (!errorsAndWarnings.isEmpty() || !ring.isEmpty()) {
            LOGGER.error("\n=== {} `{}` ===", (Object)description, (Object)this);
        }
        if (!errorsAndWarnings.isEmpty()) {
            LOGGER.lifecycle("\n\u00bb    \u2193 errors and warnings from " + from + " \u2193");
            errorsAndWarnings.forEach((message, count) -> {
                LOGGER.lifecycle("\u00bb " + message.replace("\n", "\n\u00bb  "));
                if (count > 1) {
                    LOGGER.lifecycle("\u00bb   \u2191 repeated " + count + " times \u2191");
                }
            });
        }
        ring.removeIf(line -> MESSAGES_WE_DONT_CARE_ABOUT.stream().anyMatch(line::contains));
        if (!ring.isEmpty()) {
            LOGGER.lifecycle("\u00bb   \u2193 last 40 non error or warning messages from " + from + " \u2193");
            ring.forEach(message -> {
                if (!errorsAndWarnings.containsKey(this.normalizeLogLine((String)message))) {
                    LOGGER.lifecycle("\u00bb " + message.replace("\n", "\n\u00bb  "));
                }
            });
        }
    }

    private String normalizeLogLine(String line) {
        if (line.contains("ERROR")) {
            return line.substring(line.indexOf("ERROR"));
        }
        if (line.contains("WARN")) {
            return line.substring(line.indexOf("WARN"));
        }
        return line;
    }

    private void waitForProcessToExit(ProcessHandle processHandle) {
        try {
            processHandle.onExit().get(20L, ES_DESTROY_TIMEOUT_UNIT);
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted while waiting for ES process", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.info("Failure while waiting for process to exist", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOGGER.info("Timed out waiting for process to exit", (Throwable)e);
        }
    }

    private void createWorkingDir(Path distroExtractDir) throws IOException {
        if (!Files.exists(this.getDistroDir(), new LinkOption[0])) {
            this.syncWithLinks(distroExtractDir, this.getDistroDir());
        }
        this.project.delete(new Object[]{this.configFile.getParent()});
        Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
        Files.createDirectories(this.confPathRepo, new FileAttribute[0]);
        Files.createDirectories(this.confPathData, new FileAttribute[0]);
        Files.createDirectories(this.confPathLogs, new FileAttribute[0]);
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
    }

    private void syncWithLinks(Path sourceRoot, Path destinationRoot) {
        assert (!Files.exists(destinationRoot, new LinkOption[0]));
        try (Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path relativeDestination = sourceRoot.relativize((Path)source);
                if (relativeDestination.getNameCount() <= 1) {
                    return;
                }
                relativeDestination = relativeDestination.subpath(1, relativeDestination.getNameCount());
                Path destination = destinationRoot.resolve(relativeDestination);
                if (Files.isDirectory(source, new LinkOption[0])) {
                    try {
                        Files.createDirectories(destination, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                    }
                }
                try {
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Can't create directory " + destination.getParent(), e);
                }
                try {
                    Files.createLink(destination, source);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to create hard link " + destination + " pointing to " + source, e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't walk source " + sourceRoot, e);
        }
    }

    private void createConfiguration() {
        String nodeName = this.nameCustomization.apply(this.safeName(this.name));
        if (nodeName != null) {
            this.defaultConfig.put("node.name", nodeName);
        }
        this.defaultConfig.put("path.repo", this.confPathRepo.toAbsolutePath().toString());
        this.defaultConfig.put("path.data", this.confPathData.toAbsolutePath().toString());
        this.defaultConfig.put("path.logs", this.confPathLogs.toAbsolutePath().toString());
        this.defaultConfig.put("path.shared_data", this.workingDir.resolve("sharedData").toString());
        this.defaultConfig.put("node.attr.testattr", "test");
        this.defaultConfig.put("node.portsfile", "true");
        this.defaultConfig.put("http.port", this.httpPort);
        if (this.getVersion().onOrAfter(Version.fromString("6.7.0"))) {
            this.defaultConfig.put("transport.port", this.transportPort);
        } else {
            this.defaultConfig.put("transport.tcp.port", this.transportPort);
        }
        this.defaultConfig.put("cluster.routing.allocation.disk.watermark.low", "1b");
        this.defaultConfig.put("cluster.routing.allocation.disk.watermark.high", "1b");
        this.defaultConfig.put("script.max_compilations_rate", "2048/1m");
        if (this.getVersion().getMajor() >= 6) {
            this.defaultConfig.put("cluster.routing.allocation.disk.watermark.flood_stage", "1b");
        }
        if (this.getVersion().getMajor() >= 7) {
            this.defaultConfig.put("indices.breaker.total.use_real_memory", "false");
        }
        this.defaultConfig.put("discovery.initial_state_timeout", "0s");
        this.defaultConfig.put("logger.org.elasticsearch.action.support.master", "DEBUG");
        this.defaultConfig.put("logger.org.elasticsearch.cluster.coordination", "DEBUG");
        HashSet<String> overriden = new HashSet<String>(this.defaultConfig.keySet());
        overriden.retainAll(this.settings.keySet());
        overriden.removeAll(OVERRIDABLE_SETTINGS);
        if (!overriden.isEmpty()) {
            throw new IllegalArgumentException("Testclusters does not allow the following settings to be changed:" + overriden + " for " + this);
        }
        this.settings.keySet().stream().filter(OVERRIDABLE_SETTINGS::contains).forEach(this.defaultConfig::remove);
        try {
            List configFiles;
            Files.write(this.configFile, Stream.concat(this.settings.entrySet().stream(), this.defaultConfig.entrySet().stream()).map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            try (Stream<Path> stream = Files.list(this.getDistroDir().resolve("config"));){
                configFiles = stream.collect(Collectors.toList());
            }
            this.logToProcessStdout("Copying additional config files from distro " + configFiles);
            for (Path file : configFiles) {
                Path dest = this.configFile.getParent().resolve(file.getFileName());
                if (Files.exists(dest, new LinkOption[0])) continue;
                Files.copy(file, dest, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not write config file: " + this.configFile, e);
        }
        LOGGER.info("Written config file:{} for {}", (Object)this.configFile, (Object)this);
    }

    private void checkFrozen() {
        if (this.configurationFrozen.get()) {
            throw new IllegalStateException("Configuration for " + this + " can not be altered, already locked");
        }
    }

    private List<String> getTransportPortInternal() {
        try {
            return this.readPortsFile(this.transportPortFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read transport ports file: " + this.transportPortFile + " for " + this, e);
        }
    }

    private List<String> getHttpPortInternal() {
        try {
            return this.readPortsFile(this.httpPortsFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read http ports file: " + this.httpPortsFile + " for " + this, e);
        }
    }

    private List<String> readPortsFile(Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            List<String> list = lines.map(String::trim).collect(Collectors.toList());
            return list;
        }
    }

    private Path getExtractedDistributionDir() {
        return Paths.get(this.distributions.get(this.currentDistro).getExtracted().toString(), new String[0]);
    }

    private List<File> getInstalledFileSet(Action<? super PatternFilterable> filter) {
        return Stream.concat(this.plugins.stream().map(Provider::get).filter(uri -> uri.getScheme().equalsIgnoreCase("file")).map(File::new), this.modules.stream().map(p -> (File)p.get())).filter(File::exists).map(zipFile -> this.project.zipTree(zipFile).matching(filter)).flatMap(tree -> tree.getFiles().stream()).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
    }

    @Input
    public Set<URI> getRemotePlugins() {
        Set<URI> file = this.plugins.stream().map(Provider::get).filter(uri -> !uri.getScheme().equalsIgnoreCase("file")).collect(Collectors.toSet());
        return file;
    }

    @Classpath
    public List<File> getInstalledClasspath() {
        return this.getInstalledFileSet((Action<? super PatternFilterable>)((Action)filter -> filter.include(new String[]{"**/*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getInstalledFiles() {
        return this.getInstalledFileSet((Action<? super PatternFilterable>)((Action)filter -> filter.exclude(new String[]{"**/*.jar"})));
    }

    @Classpath
    public Set<File> getDistributionClasspath() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.include(new String[]{"**/*.jar"})));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getDistributionFiles() {
        return this.getDistributionFiles((Action<PatternFilterable>)((Action)filter -> filter.exclude(new String[]{"**/*.jar"})));
    }

    private Set<File> getDistributionFiles(Action<PatternFilterable> patternFilter) {
        TreeSet<File> files = new TreeSet<File>();
        for (ElasticsearchDistribution distribution : this.distributions) {
            files.addAll(this.project.fileTree((Object)Paths.get(distribution.getExtracted().toString(), new String[0])).matching(patternFilter).getFiles());
        }
        return files;
    }

    @Nested
    public List<?> getKeystoreSettings() {
        return this.keystoreSettings.getNormalizedCollection();
    }

    @Nested
    public List<?> getKeystoreFiles() {
        return this.keystoreFiles.getNormalizedCollection();
    }

    @Nested
    public List<?> getCliSetup() {
        return this.cliSetup.getFlatNormalizedCollection();
    }

    @Nested
    public List<?> getSettings() {
        return this.settings.getNormalizedCollection();
    }

    @Nested
    public List<?> getSystemProperties() {
        return this.systemProperties.getNormalizedCollection();
    }

    @Nested
    public List<?> getEnvironment() {
        return this.environment.getNormalizedCollection();
    }

    @Nested
    public List<?> getJvmArgs() {
        return this.jvmArgs.getNormalizedCollection();
    }

    @Nested
    public List<?> getExtraConfigFiles() {
        return this.extraConfigFiles.getNormalizedCollection();
    }

    @Override
    @Internal
    public boolean isProcessAlive() {
        Objects.requireNonNull(this.esProcess, "Can't wait for `" + this + "` as it's not started. Does the task have `useCluster` ?");
        return this.esProcess.isAlive();
    }

    void waitForAllConditions() {
        this.waitForConditions(this.waitConditions, System.currentTimeMillis(), NODE_UP_TIMEOUT_UNIT.toMillis(2L) + ADDITIONAL_CONFIG_TIMEOUT_UNIT.toMillis(15 * (this.plugins.size() + this.keystoreFiles.size() + this.keystoreSettings.size() + this.credentials.size())), TimeUnit.MILLISECONDS, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchNode that = (ElasticsearchNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.path);
    }

    public String toString() {
        return "node{" + this.path + ":" + this.name + "}";
    }

    @Input
    List<Map<String, String>> getCredentials() {
        return this.credentials;
    }

    private boolean checkPortsFilesExistWithDelay(TestClusterConfiguration node) {
        if (Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0])) {
            return true;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TestClustersException("Interrupted while waiting for ports files", e);
        }
        return Files.exists(this.httpPortsFile, new LinkOption[0]) && Files.exists(this.transportPortFile, new LinkOption[0]);
    }

    @Internal
    public boolean isHttpSslEnabled() {
        return Boolean.valueOf(this.settings.getOrDefault("xpack.security.http.ssl.enabled", "false").toString());
    }

    void configureHttpWait(WaitForHttpResource wait) {
        if (this.settings.containsKey("xpack.security.http.ssl.certificate_authorities")) {
            wait.setCertificateAuthorities(this.getConfigDir().resolve(this.settings.get("xpack.security.http.ssl.certificate_authorities").toString()).toFile());
        }
        if (this.settings.containsKey("xpack.security.http.ssl.certificate")) {
            wait.setCertificateAuthorities(this.getConfigDir().resolve(this.settings.get("xpack.security.http.ssl.certificate").toString()).toFile());
        }
        if (this.settings.containsKey("xpack.security.http.ssl.keystore.path")) {
            wait.setTrustStoreFile(this.getConfigDir().resolve(this.settings.get("xpack.security.http.ssl.keystore.path").toString()).toFile());
        }
        if (this.keystoreSettings.containsKey("xpack.security.http.ssl.keystore.secure_password")) {
            wait.setTrustStorePassword(this.keystoreSettings.get("xpack.security.http.ssl.keystore.secure_password").toString());
        }
    }

    void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
    }

    void setTransportPort(String transportPort) {
        this.transportPort = transportPort;
    }

    void setDataPath(Path dataPath) {
        this.confPathData = dataPath;
    }

    @Internal
    Path getEsStdoutFile() {
        return this.esStdoutFile;
    }

    @Internal
    Path getEsStderrFile() {
        return this.esStderrFile;
    }

    private static class CliEntry {
        private String executable;
        private CharSequence[] args;

        CliEntry(String executable, CharSequence[] args) {
            this.executable = executable;
            this.args = args;
        }

        @Input
        public String getExecutable() {
            return this.executable;
        }

        @Input
        public CharSequence[] getArgs() {
            return this.args;
        }
    }

    private static class FileEntry
    implements Named {
        private String name;
        private File file;

        FileEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @InputFile
        @PathSensitive(value=PathSensitivity.NONE)
        public File getFile() {
            return this.file;
        }
    }
}

