/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test.rest;

import java.util.Map;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.test.rest.CopyRestApiTask;
import org.elasticsearch.gradle.test.rest.CopyRestTestsTask;
import org.elasticsearch.gradle.test.rest.RestResourcesExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class RestResourcesPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "restResources";

    public void apply(Project project) {
        RestResourcesExtension extension = (RestResourcesExtension)project.getExtensions().create(EXTENSION_NAME, RestResourcesExtension.class, new Object[0]);
        Configuration testConfig = (Configuration)project.getConfigurations().create("restTestConfig");
        Configuration xpackTestConfig = (Configuration)project.getConfigurations().create("restXpackTestConfig");
        project.getConfigurations().create("restTests");
        project.getConfigurations().create("restXpackTests");
        TaskProvider copyRestYamlTestTask = project.getTasks().register("copyYamlTestsTask", CopyRestTestsTask.class, task -> {
            task.includeCore.set(extension.restTests.getIncludeCore());
            task.includeXpack.set(extension.restTests.getIncludeXpack());
            task.coreConfig = testConfig;
            if (BuildParams.isInternal().booleanValue()) {
                Dependency restTestdependency = project.getDependencies().project(Map.of("path", ":rest-api-spec", "configuration", "restTests"));
                project.getDependencies().add(task.coreConfig.getName(), (Object)restTestdependency);
                task.xpackConfig = xpackTestConfig;
                Dependency restXPackTestdependency = project.getDependencies().project(Map.of("path", ":x-pack:plugin", "configuration", "restXpackTests"));
                project.getDependencies().add(task.xpackConfig.getName(), (Object)restXPackTestdependency);
                task.dependsOn(new Object[]{task.xpackConfig});
            } else {
                Dependency dependency = project.getDependencies().create((Object)("org.elasticsearch:rest-api-spec:" + VersionProperties.getElasticsearch()));
                project.getDependencies().add(task.coreConfig.getName(), (Object)dependency);
            }
            task.dependsOn(new Object[]{task.coreConfig});
        });
        Configuration specConfig = (Configuration)project.getConfigurations().create("restSpec");
        Configuration xpackSpecConfig = (Configuration)project.getConfigurations().create("restXpackSpec");
        project.getConfigurations().create("restSpecs");
        project.getConfigurations().create("restXpackSpecs");
        TaskProvider copyRestYamlSpecTask = project.getTasks().register("copyRestApiSpecsTask", CopyRestApiTask.class, arg_0 -> RestResourcesPlugin.lambda$apply$1(extension, (Provider)copyRestYamlTestTask, specConfig, project, xpackSpecConfig, arg_0));
        project.getTasks().named("processTestResources").configure(arg_0 -> RestResourcesPlugin.lambda$apply$2((Provider)copyRestYamlSpecTask, arg_0));
    }

    private static /* synthetic */ void lambda$apply$2(Provider copyRestYamlSpecTask, Task t) {
        t.dependsOn(new Object[]{copyRestYamlSpecTask});
    }

    private static /* synthetic */ void lambda$apply$1(RestResourcesExtension extension, Provider copyRestYamlTestTask, Configuration specConfig, Project project, Configuration xpackSpecConfig, CopyRestApiTask task) {
        task.includeCore.set(extension.restApi.getIncludeCore());
        task.includeXpack.set(extension.restApi.getIncludeXpack());
        task.dependsOn(new Object[]{copyRestYamlTestTask});
        task.coreConfig = specConfig;
        if (BuildParams.isInternal().booleanValue()) {
            Dependency restSpecDependency = project.getDependencies().project(Map.of("path", ":rest-api-spec", "configuration", "restSpecs"));
            project.getDependencies().add(task.coreConfig.getName(), (Object)restSpecDependency);
            task.xpackConfig = xpackSpecConfig;
            Dependency restXpackSpecDependency = project.getDependencies().project(Map.of("path", ":x-pack:plugin", "configuration", "restXpackSpecs"));
            project.getDependencies().add(task.xpackConfig.getName(), (Object)restXpackSpecDependency);
            task.dependsOn(new Object[]{task.xpackConfig});
        } else {
            Dependency dependency = project.getDependencies().create((Object)("org.elasticsearch:rest-api-spec:" + VersionProperties.getElasticsearch()));
            project.getDependencies().add(task.coreConfig.getName(), (Object)dependency);
        }
        task.dependsOn(new Object[]{task.coreConfig});
    }
}

