/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test.rest;

import javax.inject.Inject;
import org.elasticsearch.gradle.info.BuildParams;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;

public class RestResourcesExtension {
    final RestResourcesSpec restApi;
    final RestResourcesSpec restTests;

    @Inject
    public RestResourcesExtension(ObjectFactory objects) {
        this.restApi = new RestResourcesSpec(objects);
        this.restTests = new RestResourcesSpec(objects);
    }

    void restApi(Action<? super RestResourcesSpec> spec) {
        spec.execute((Object)this.restApi);
    }

    void restTests(Action<? super RestResourcesSpec> spec) {
        spec.execute((Object)this.restTests);
    }

    static class RestResourcesSpec {
        private final ListProperty<String> includeCore;
        private final ListProperty<String> includeXpack;

        RestResourcesSpec(ObjectFactory objects) {
            this.includeCore = objects.listProperty(String.class);
            this.includeXpack = objects.listProperty(String.class);
        }

        public void includeCore(String ... include) {
            this.includeCore.addAll((Object[])include);
        }

        public void includeXpack(String ... include) {
            if (!BuildParams.isInternal().booleanValue()) {
                throw new IllegalStateException("Can not include x-pack rest resources from an external build.");
            }
            this.includeXpack.addAll((Object[])include);
        }

        public ListProperty<String> getIncludeCore() {
            return this.includeCore;
        }

        public ListProperty<String> getIncludeXpack() {
            return this.includeXpack;
        }
    }
}

