/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test.rest;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class CopyRestTestsTask
extends DefaultTask {
    private static final String REST_TEST_PREFIX = "rest-api-spec/test";
    final ListProperty<String> includeCore = this.getProject().getObjects().listProperty(String.class);
    final ListProperty<String> includeXpack = this.getProject().getObjects().listProperty(String.class);
    Configuration coreConfig;
    Configuration xpackConfig;
    private final PatternFilterable corePatternSet = (PatternFilterable)this.getPatternSetFactory().create();
    private final PatternFilterable xpackPatternSet = (PatternFilterable)this.getPatternSetFactory().create();

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @Input
    public ListProperty<String> getIncludeCore() {
        return this.includeCore;
    }

    @Input
    public ListProperty<String> getIncludeXpack() {
        return this.includeXpack;
    }

    @SkipWhenEmpty
    @InputFiles
    public FileTree getInputDir() {
        FileTree coreFileTree = null;
        FileTree xpackFileTree = null;
        if (!((List)this.includeXpack.get()).isEmpty()) {
            this.xpackPatternSet.setIncludes((Iterable)((List)this.includeXpack.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
            xpackFileTree = this.xpackConfig.getAsFileTree().matching(this.xpackPatternSet);
        }
        if (!((List)this.includeCore.get()).isEmpty()) {
            if (BuildParams.isInternal().booleanValue()) {
                this.corePatternSet.setIncludes((Iterable)((List)this.includeCore.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
                coreFileTree = this.coreConfig.getAsFileTree().matching(this.corePatternSet);
            } else {
                coreFileTree = this.coreConfig.getAsFileTree();
            }
        }
        ConfigurableFileCollection fileCollection = this.getProject().files(new Object[]{coreFileTree, xpackFileTree});
        return !((List)this.includeCore.get()).isEmpty() || !((List)this.includeXpack.get()).isEmpty() ? fileCollection.getAsFileTree() : null;
    }

    @OutputDirectory
    public File getOutputDir() {
        return new File(this.getTestSourceSet().getOutput().getResourcesDir(), REST_TEST_PREFIX);
    }

    @TaskAction
    void copy() {
        Project project = this.getProject();
        if (!((List)this.includeCore.get()).isEmpty()) {
            if (BuildParams.isInternal().booleanValue()) {
                this.getLogger().debug("Rest tests for project [{}] will be copied to the test resources.", (Object)project.getPath());
                project.copy(c -> {
                    c.from(new Object[]{this.coreConfig.getAsFileTree()});
                    c.into((Object)this.getOutputDir());
                    c.include((Iterable)this.corePatternSet.getIncludes());
                });
            } else {
                this.getLogger().debug("Rest tests for project [{}] will be copied to the test resources from the published jar (version: [{}]).", (Object)project.getPath(), (Object)VersionProperties.getElasticsearch());
                project.copy(c -> {
                    c.from(new Object[]{project.zipTree((Object)this.coreConfig.getSingleFile())});
                    c.into((Object)this.getTestSourceSet().getOutput().getResourcesDir());
                    c.include((Iterable)((List)this.includeCore.get()).stream().map(prefix -> "rest-api-spec/test/" + prefix + "*/**").collect(Collectors.toList()));
                });
            }
        }
        if (!((List)this.includeXpack.get()).isEmpty()) {
            this.getLogger().debug("X-pack rest tests for project [{}] will be copied to the test resources.", (Object)project.getPath());
            project.copy(c -> {
                c.from(new Object[]{this.xpackConfig.getAsFileTree()});
                c.into((Object)this.getOutputDir());
                c.include((Iterable)this.xpackPatternSet.getIncludes());
            });
        }
    }

    private SourceSet getTestSourceSet() {
        return (SourceSet)GradleUtils.getJavaSourceSets(this.getProject()).findByName("test");
    }
}

