/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test.rest;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class CopyRestApiTask
extends DefaultTask {
    private static final String REST_API_PREFIX = "rest-api-spec/api";
    final ListProperty<String> includeCore = this.getProject().getObjects().listProperty(String.class);
    final ListProperty<String> includeXpack = this.getProject().getObjects().listProperty(String.class);
    Configuration coreConfig;
    Configuration xpackConfig;
    private final PatternFilterable corePatternSet = (PatternFilterable)this.getPatternSetFactory().create();
    private final PatternFilterable xpackPatternSet = (PatternFilterable)this.getPatternSetFactory().create();

    @Inject
    protected Factory<PatternSet> getPatternSetFactory() {
        throw new UnsupportedOperationException();
    }

    @Input
    public ListProperty<String> getIncludeCore() {
        return this.includeCore;
    }

    @Input
    public ListProperty<String> getIncludeXpack() {
        return this.includeXpack;
    }

    @SkipWhenEmpty
    @InputFiles
    public FileTree getInputDir() {
        FileTree coreFileTree = null;
        FileTree xpackFileTree = null;
        if (!((List)this.includeXpack.get()).isEmpty()) {
            this.xpackPatternSet.setIncludes((Iterable)((List)this.includeXpack.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
            xpackFileTree = this.xpackConfig.getAsFileTree().matching(this.xpackPatternSet);
        }
        boolean projectHasYamlRestTests = this.projectHasYamlRestTests();
        if (!((List)this.includeCore.get()).isEmpty() || projectHasYamlRestTests) {
            if (BuildParams.isInternal().booleanValue()) {
                this.corePatternSet.setIncludes((Iterable)((List)this.includeCore.get()).stream().map(prefix -> prefix + "*/**").collect(Collectors.toList()));
                coreFileTree = this.coreConfig.getAsFileTree().matching(this.corePatternSet);
            } else {
                coreFileTree = this.coreConfig.getAsFileTree();
            }
        }
        ConfigurableFileCollection fileCollection = this.getProject().files(new Object[]{coreFileTree, xpackFileTree});
        return projectHasYamlRestTests || !((List)this.includeCore.get()).isEmpty() || !((List)this.includeXpack.get()).isEmpty() ? fileCollection.getAsFileTree() : null;
    }

    @OutputDirectory
    public File getOutputDir() {
        return new File(this.getTestSourceSet().getOutput().getResourcesDir(), REST_API_PREFIX);
    }

    @TaskAction
    void copy() {
        Project project = this.getProject();
        if (BuildParams.isInternal().booleanValue()) {
            this.getLogger().debug("Rest specs for project [{}] will be copied to the test resources.", (Object)project.getPath());
            project.copy(c -> {
                c.from(new Object[]{this.coreConfig.getSingleFile()});
                c.into((Object)this.getOutputDir());
                c.include((Iterable)this.corePatternSet.getIncludes());
            });
        } else {
            this.getLogger().debug("Rest specs for project [{}] will be copied to the test resources from the published jar (version: [{}]).", (Object)project.getPath(), (Object)VersionProperties.getElasticsearch());
            project.copy(c -> {
                c.from(new Object[]{project.zipTree((Object)this.coreConfig.getSingleFile())});
                c.into((Object)this.getTestSourceSet().getOutput().getResourcesDir());
                if (((List)this.includeCore.get()).isEmpty()) {
                    c.include(new String[]{"rest-api-spec/api/**"});
                } else {
                    c.include((Iterable)((List)this.includeCore.get()).stream().map(prefix -> "rest-api-spec/api/" + prefix + "*/**").collect(Collectors.toList()));
                }
            });
        }
        if (!((List)this.includeXpack.get()).isEmpty()) {
            this.getLogger().debug("X-pack rest specs for project [{}] will be copied to the test resources.", (Object)project.getPath());
            project.copy(c -> {
                c.from(new Object[]{this.xpackConfig.getSingleFile()});
                c.into((Object)this.getOutputDir());
                c.include((Iterable)this.xpackPatternSet.getIncludes());
            });
        }
    }

    private boolean projectHasYamlRestTests() {
        File testSourceResourceDir = this.getTestSourceResourceDir();
        File testOutputResourceDir = this.getTestOutputResourceDir();
        if (testSourceResourceDir == null && testOutputResourceDir == null) {
            return false;
        }
        try {
            if (testSourceResourceDir != null && new File(testSourceResourceDir, "rest-api-spec/test").exists()) {
                return Files.walk(testSourceResourceDir.toPath().resolve("rest-api-spec/test"), new FileVisitOption[0]).anyMatch(p -> p.getFileName().toString().endsWith("yml"));
            }
            if (testOutputResourceDir != null && new File(testOutputResourceDir, "rest-api-spec/test").exists()) {
                return Files.walk(testOutputResourceDir.toPath().resolve("rest-api-spec/test"), new FileVisitOption[0]).anyMatch(p -> p.getFileName().toString().endsWith("yml"));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error determining if this project [%s] has rest tests.", this.getProject()), e);
        }
        return false;
    }

    private File getTestSourceResourceDir() {
        SourceSet testSources = this.getTestSourceSet();
        if (testSources == null) {
            return null;
        }
        Set resourceDir = testSources.getResources().getSrcDirs().stream().filter(f -> f.isDirectory() && f.getParentFile().getName().equals("test") && f.getName().equals("resources")).collect(Collectors.toSet());
        assert (resourceDir.size() <= 1);
        if (resourceDir.size() == 0) {
            return null;
        }
        return (File)resourceDir.iterator().next();
    }

    private File getTestOutputResourceDir() {
        SourceSet testSources = this.getTestSourceSet();
        if (testSources == null) {
            return null;
        }
        return testSources.getOutput().getResourcesDir();
    }

    private SourceSet getTestSourceSet() {
        return (SourceSet)GradleUtils.getJavaSourceSets(this.getProject()).findByName("test");
    }
}

