/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import org.elasticsearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.elasticsearch.gradle.test.Fixture;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.RestTestRunnerTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class RestIntegTestTask
extends DefaultTask {
    protected RestTestRunnerTask runner;
    private static final String TESTS_REST_CLUSTER = "tests.rest.cluster";
    private static final String TESTS_CLUSTER = "tests.cluster";
    private static final String TESTS_CLUSTER_NAME = "tests.clustername";

    public RestIntegTestTask() {
        Project project = this.getProject();
        String name = this.getName();
        this.runner = (RestTestRunnerTask)project.getTasks().create(name + "Runner", RestTestRunnerTask.class);
        super.dependsOn(new Object[]{this.runner});
        NamedDomainObjectContainer testClusters = (NamedDomainObjectContainer)project.getExtensions().getByName("testClusters");
        ElasticsearchCluster cluster = (ElasticsearchCluster)testClusters.create(name);
        this.runner.useCluster(cluster);
        this.runner.include(new String[]{"**/*IT.class"});
        this.runner.systemProperty("tests.rest.load_packaged", Boolean.FALSE.toString());
        if (System.getProperty(TESTS_REST_CLUSTER) == null) {
            if (System.getProperty(TESTS_CLUSTER) != null || System.getProperty(TESTS_CLUSTER_NAME) != null) {
                throw new IllegalArgumentException(String.format("%s, %s, and %s must all be null or non-null", TESTS_REST_CLUSTER, TESTS_CLUSTER, TESTS_CLUSTER_NAME));
            }
            SystemPropertyCommandLineArgumentProvider runnerNonInputProperties = (SystemPropertyCommandLineArgumentProvider)this.runner.getExtensions().getByName("nonInputProperties");
            runnerNonInputProperties.systemProperty(TESTS_REST_CLUSTER, () -> String.join((CharSequence)",", cluster.getAllHttpSocketURI()));
            runnerNonInputProperties.systemProperty(TESTS_CLUSTER, () -> String.join((CharSequence)",", cluster.getAllTransportPortURI()));
            runnerNonInputProperties.systemProperty(TESTS_CLUSTER_NAME, cluster::getName);
        } else if (System.getProperty(TESTS_CLUSTER) == null || System.getProperty(TESTS_CLUSTER_NAME) == null) {
            throw new IllegalArgumentException(String.format("%s, %s, and %s must all be null or non-null", TESTS_REST_CLUSTER, TESTS_CLUSTER, TESTS_CLUSTER_NAME));
        }
        project.getGradle().projectsEvaluated(x -> {
            if (!this.isEnabled()) {
                this.runner.setEnabled(false);
            }
        });
    }

    public Task dependsOn(Object ... dependencies) {
        this.runner.dependsOn(dependencies);
        for (Object dependency : dependencies) {
            if (!(dependency instanceof Fixture)) continue;
            this.runner.finalizedBy(new Object[]{((Fixture)dependency).getStopTask()});
        }
        return this;
    }

    public void setDependsOn(Iterable<?> dependencies) {
        this.runner.setDependsOn(dependencies);
        for (Object dependency : dependencies) {
            if (!(dependency instanceof Fixture)) continue;
            this.runner.finalizedBy(new Object[]{((Fixture)dependency).getStopTask()});
        }
    }

    public void runner(Action<? super RestTestRunnerTask> configure) {
        configure.execute((Object)this.runner);
    }
}

