/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.BwcVersions;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.ElasticsearchDistribution;
import org.elasticsearch.gradle.Jdk;
import org.elasticsearch.gradle.JdkDownloadPlugin;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.docker.DockerSupportPlugin;
import org.elasticsearch.gradle.docker.DockerSupportService;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.test.BatsTestTask;
import org.elasticsearch.gradle.test.GradleDistroTestTask;
import org.elasticsearch.gradle.util.GradleUtils;
import org.elasticsearch.gradle.vagrant.BatsProgressLogger;
import org.elasticsearch.gradle.vagrant.VagrantBasePlugin;
import org.elasticsearch.gradle.vagrant.VagrantExtension;
import org.elasticsearch.gradle.vagrant.VagrantMachine;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class DistroTestPlugin
implements Plugin<Project> {
    private static final String GRADLE_JDK_VERSION = "14+36@076bab302c7b4508975440c56f6cc26a";
    private static final String GRADLE_JDK_VENDOR = "openjdk";
    private static final String DISTRIBUTIONS_CONFIGURATION = "distributions";
    private static final String UPGRADE_CONFIGURATION = "upgradeDistributions";
    private static final String PLUGINS_CONFIGURATION = "packagingPlugins";
    private static final String COPY_DISTRIBUTIONS_TASK = "copyDistributions";
    private static final String COPY_UPGRADE_TASK = "copyUpgradePackages";
    private static final String COPY_PLUGINS_TASK = "copyPlugins";
    private static final String IN_VM_SYSPROP = "tests.inVM";
    private static final String DISTRIBUTION_SYSPROP = "tests.distribution";

    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(DockerSupportPlugin.class);
        project.getPluginManager().apply(DistributionDownloadPlugin.class);
        project.getPluginManager().apply("elasticsearch.build");
        Provider dockerSupport = GradleUtils.getBuildService(project.getGradle().getSharedServices(), "dockerSupportService");
        Version upgradeVersion = DistroTestPlugin.getUpgradeVersion(project);
        Provider distributionsDir = project.getLayout().getBuildDirectory().dir("packaging/distributions");
        Provider upgradeDir = project.getLayout().getBuildDirectory().dir("packaging/upgrade");
        Provider pluginsDir = project.getLayout().getBuildDirectory().dir("packaging/plugins");
        List<ElasticsearchDistribution> distributions = this.configureDistributions(project, upgradeVersion);
        TaskProvider<Copy> copyDistributionsTask = DistroTestPlugin.configureCopyDistributionsTask(project, (Provider<Directory>)distributionsDir);
        TaskProvider<Copy> copyUpgradeTask = DistroTestPlugin.configureCopyUpgradeTask(project, upgradeVersion, (Provider<Directory>)upgradeDir);
        TaskProvider<Copy> copyPluginsTask = DistroTestPlugin.configureCopyPluginsTask(project, (Provider<Directory>)pluginsDir);
        Map<ElasticsearchDistribution.Type, TaskProvider<?>> lifecyleTasks = DistroTestPlugin.lifecyleTasks(project, "destructiveDistroTest");
        TaskProvider destructiveDistroTest = project.getTasks().register("destructiveDistroTest");
        for (ElasticsearchDistribution distribution : distributions) {
            TaskProvider<?> destructiveTask = DistroTestPlugin.configureDistroTest(project, distribution, dockerSupport);
            destructiveDistroTest.configure(t -> t.dependsOn(new Object[]{destructiveTask}));
            lifecyleTasks.get((Object)distribution.getType()).configure(t -> t.dependsOn(new Object[]{destructiveTask}));
        }
        HashMap batsTests = new HashMap();
        DistroTestPlugin.configureBatsTest(project, "plugins", (Provider<Directory>)distributionsDir, copyDistributionsTask, copyPluginsTask).configure(t -> t.setPluginsDir((Provider<Directory>)pluginsDir));
        DistroTestPlugin.configureBatsTest(project, "upgrade", (Provider<Directory>)distributionsDir, copyDistributionsTask, copyUpgradeTask).configure(t -> t.setUpgradeDir((Provider<Directory>)upgradeDir));
        project.subprojects(vmProject -> {
            vmProject.getPluginManager().apply(VagrantBasePlugin.class);
            vmProject.getPluginManager().apply(JdkDownloadPlugin.class);
            ArrayList<Object> vmDependencies = new ArrayList<Object>(DistroTestPlugin.configureVM(vmProject));
            vmDependencies.add(project.getConfigurations().getByName("testRuntimeClasspath"));
            Map<ElasticsearchDistribution.Type, TaskProvider<?>> vmLifecyleTasks = DistroTestPlugin.lifecyleTasks(vmProject, "distroTest");
            TaskProvider distroTest = vmProject.getTasks().register("distroTest");
            for (ElasticsearchDistribution distribution : distributions) {
                String destructiveTaskName = DistroTestPlugin.destructiveDistroTestTaskName(distribution);
                ElasticsearchDistribution.Platform platform = distribution.getPlatform();
                if (DistroTestPlugin.isWindows(vmProject) != (platform == ElasticsearchDistribution.Platform.WINDOWS)) continue;
                TaskProvider<GradleDistroTestTask> vmTask = DistroTestPlugin.configureVMWrapperTask(vmProject, distribution.getName() + " distribution", destructiveTaskName, vmDependencies);
                vmTask.configure(t -> t.dependsOn(new Object[]{distribution}));
                vmLifecyleTasks.get((Object)distribution.getType()).configure(t -> t.dependsOn(new Object[]{vmTask}));
                distroTest.configure(t -> {
                    boolean shouldExecute;
                    boolean bl = shouldExecute = distribution.getType() != ElasticsearchDistribution.Type.DOCKER || Boolean.TRUE.equals(vmProject.findProperty("shouldTestDocker"));
                    if (shouldExecute) {
                        t.dependsOn(new Object[]{vmTask});
                    }
                });
            }
            batsTests.forEach((desc, task) -> DistroTestPlugin.configureVMWrapperTask(vmProject, desc, task.getName(), vmDependencies).configure(t -> {
                t.setProgressHandler(new BatsProgressLogger(project.getLogger()));
                t.onlyIf(spec -> !DistroTestPlugin.isWindows(vmProject));
                t.dependsOn(new Object[]{copyDistributionsTask});
            }));
        });
    }

    private static Map<ElasticsearchDistribution.Type, TaskProvider<?>> lifecyleTasks(Project project, String taskPrefix) {
        HashMap lifecyleTasks = new HashMap();
        lifecyleTasks.put(ElasticsearchDistribution.Type.DOCKER, project.getTasks().register(taskPrefix + ".docker"));
        lifecyleTasks.put(ElasticsearchDistribution.Type.ARCHIVE, project.getTasks().register(taskPrefix + ".archives"));
        lifecyleTasks.put(ElasticsearchDistribution.Type.DEB, project.getTasks().register(taskPrefix + ".packages"));
        lifecyleTasks.put(ElasticsearchDistribution.Type.RPM, (TaskProvider)lifecyleTasks.get((Object)ElasticsearchDistribution.Type.DEB));
        return lifecyleTasks;
    }

    private static Jdk createJdk(NamedDomainObjectContainer<Jdk> jdksContainer, String name, String vendor, String version, String platform, String architecture) {
        Jdk jdk = (Jdk)jdksContainer.create(name);
        jdk.setVendor(vendor);
        jdk.setVersion(version);
        jdk.setPlatform(platform);
        jdk.setArchitecture(architecture);
        return jdk;
    }

    private static Version getUpgradeVersion(Project project) {
        String upgradeFromVersionRaw = System.getProperty("tests.packaging.upgradeVersion");
        if (upgradeFromVersionRaw != null) {
            return Version.fromString(upgradeFromVersionRaw);
        }
        ExtraPropertiesExtension extraProperties = (ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class);
        if (!((Boolean)extraProperties.get("bwc_tests_enabled")).booleanValue()) {
            return Version.fromString(project.getVersion().toString());
        }
        String firstPartOfSeed = BuildParams.getTestSeed().split(":")[0];
        long seed = Long.parseUnsignedLong(firstPartOfSeed, 16);
        BwcVersions bwcVersions = (BwcVersions)extraProperties.get("bwcVersions");
        List<Version> indexCompatVersions = bwcVersions.getIndexCompatible();
        return indexCompatVersions.get(new Random(seed).nextInt(indexCompatVersions.size()));
    }

    private static List<Object> configureVM(Project project) {
        String box = project.getName();
        NamedDomainObjectContainer<Jdk> jdksContainer = JdkDownloadPlugin.getContainer(project);
        String platform = box.contains("windows") ? "windows" : "linux";
        Jdk gradleJdk = DistroTestPlugin.createJdk(jdksContainer, "gradle", GRADLE_JDK_VENDOR, GRADLE_JDK_VERSION, platform, "x64");
        VagrantExtension vagrant = (VagrantExtension)project.getExtensions().getByType(VagrantExtension.class);
        vagrant.setBox(box);
        vagrant.vmEnv("PATH", DistroTestPlugin.convertPath(project, vagrant, gradleJdk, "/bin:$PATH", "\\bin;$Env:PATH"));
        if (System.getenv("JENKINS_URL") != null) {
            Stream.of("JOB_NAME", "JENKINS_URL", "BUILD_NUMBER", "BUILD_URL").forEach(name -> vagrant.vmEnv((String)name, System.getenv(name)));
        }
        vagrant.setIsWindowsVM(DistroTestPlugin.isWindows(project));
        return Arrays.asList(gradleJdk);
    }

    private static Object convertPath(final Project project, final VagrantExtension vagrant, final Jdk jdk, final String additionaLinux, final String additionalWindows) {
        return new Object(){

            public String toString() {
                if (vagrant.isWindowsVM()) {
                    return VagrantMachine.convertWindowsPath(project, jdk.getPath()) + additionalWindows;
                }
                return VagrantMachine.convertLinuxPath(project, jdk.getPath()) + additionaLinux;
            }
        };
    }

    private static TaskProvider<Copy> configureCopyDistributionsTask(Project project, Provider<Directory> distributionsDir) {
        return project.getTasks().register(COPY_DISTRIBUTIONS_TASK, Copy.class, t -> {
            t.into((Object)distributionsDir);
            t.from(new Object[]{project.getConfigurations().getByName(DISTRIBUTIONS_CONFIGURATION)});
            Path distributionsPath = ((Directory)distributionsDir.get()).getAsFile().toPath();
            TaskInputsInternal inputs = t.getInputs();
            inputs.property("version", (Object)VersionProperties.getElasticsearch());
            t.doLast(action -> {
                try {
                    Files.write(distributionsPath.resolve("version"), VersionProperties.getElasticsearch().getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        });
    }

    private static TaskProvider<Copy> configureCopyUpgradeTask(Project project, Version upgradeVersion, Provider<Directory> upgradeDir) {
        return project.getTasks().register(COPY_UPGRADE_TASK, Copy.class, t -> {
            t.into((Object)upgradeDir);
            t.from(new Object[]{project.getConfigurations().getByName(UPGRADE_CONFIGURATION)});
            Path upgradePath = ((Directory)upgradeDir.get()).getAsFile().toPath();
            ExtraPropertiesExtension extraProperties = (ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class);
            BwcVersions bwcVersions = (BwcVersions)extraProperties.get("bwcVersions");
            Object upgradeFromVersion = bwcVersions.unreleasedInfo(upgradeVersion) != null ? upgradeVersion.toString() + "-SNAPSHOT" : upgradeVersion.toString();
            TaskInputsInternal inputs = t.getInputs();
            inputs.property("upgrade_from_version", upgradeFromVersion);
            t.doLast(arg_0 -> DistroTestPlugin.lambda$configureCopyUpgradeTask$14(upgradePath, (String)upgradeFromVersion, project, upgradeVersion, arg_0));
        });
    }

    private static TaskProvider<Copy> configureCopyPluginsTask(Project project, Provider<Directory> pluginsDir) {
        Configuration pluginsConfiguration = (Configuration)project.getConfigurations().create(PLUGINS_CONFIGURATION);
        return project.getTasks().register(COPY_PLUGINS_TASK, Copy.class, t -> {
            t.into((Object)pluginsDir);
            t.from(new Object[]{pluginsConfiguration});
        });
    }

    private static TaskProvider<GradleDistroTestTask> configureVMWrapperTask(Project project, String type, String destructiveTaskPath, List<Object> dependsOn) {
        int taskNameStart = destructiveTaskPath.lastIndexOf(58) + "destructive".length() + 1;
        Object taskname = destructiveTaskPath.substring(taskNameStart);
        taskname = ((String)taskname).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)taskname).substring(1);
        return project.getTasks().register((String)taskname, GradleDistroTestTask.class, t -> {
            t.setGroup("verification");
            t.setDescription("Runs " + type + " tests within vagrant");
            t.setTaskName(destructiveTaskPath);
            t.extraArg("-D'tests.inVM'");
            t.dependsOn(new Object[]{dependsOn});
        });
    }

    private static TaskProvider<?> configureDistroTest(Project project, ElasticsearchDistribution distribution, Provider<DockerSupportService> dockerSupport) {
        return project.getTasks().register(DistroTestPlugin.destructiveDistroTestTaskName(distribution), Test.class, t -> {
            t.onlyIf(t2 -> distribution.getType() != ElasticsearchDistribution.Type.DOCKER || ((DockerSupportService)dockerSupport.get()).getDockerAvailability().isAvailable);
            t.onlyIf(t3 -> distribution.getArchitecture() == Architecture.current());
            t.getOutputs().doNotCacheIf("Build cache is disabled for packaging tests", Specs.satisfyAll());
            t.setMaxParallelForks(1);
            t.setWorkingDir(project.getProjectDir());
            t.systemProperty(DISTRIBUTION_SYSPROP, (Object)distribution.toString());
            if (System.getProperty(IN_VM_SYSPROP) == null) {
                t.dependsOn(new Object[]{distribution});
            }
        });
    }

    private static TaskProvider<BatsTestTask> configureBatsTest(Project project, String type, Provider<Directory> distributionsDir, Object ... deps) {
        return project.getTasks().register("destructiveBatsTest." + type, BatsTestTask.class, t -> {
            Directory batsDir = project.getLayout().getProjectDirectory().dir("bats");
            t.setTestsDir(batsDir.dir(type));
            t.setUtilsDir(batsDir.dir("utils"));
            t.setDistributionsDir(distributionsDir);
            t.setPackageName("elasticsearch" + (type.equals("oss") ? "-oss" : ""));
            if (System.getProperty(IN_VM_SYSPROP) == null) {
                t.dependsOn(deps);
            }
        });
    }

    private List<ElasticsearchDistribution> configureDistributions(Project project, Version upgradeVersion) {
        NamedDomainObjectContainer<ElasticsearchDistribution> distributions = DistributionDownloadPlugin.getContainer(project);
        ArrayList<ElasticsearchDistribution> currentDistros = new ArrayList<ElasticsearchDistribution>();
        ArrayList<ElasticsearchDistribution> upgradeDistros = new ArrayList<ElasticsearchDistribution>();
        for (Architecture architecture : Architecture.values()) {
            for (ElasticsearchDistribution.Type type : Arrays.asList(ElasticsearchDistribution.Type.DEB, ElasticsearchDistribution.Type.RPM, ElasticsearchDistribution.Type.DOCKER)) {
                for (ElasticsearchDistribution.Flavor flavor : ElasticsearchDistribution.Flavor.values()) {
                    for (boolean bundledJdk : Arrays.asList(true, false)) {
                        boolean skip = !bundledJdk && (type == ElasticsearchDistribution.Type.DOCKER || architecture == Architecture.AARCH64);
                        if (skip) continue;
                        DistroTestPlugin.addDistro(distributions, architecture, type, null, flavor, bundledJdk, VersionProperties.getElasticsearch(), currentDistros);
                    }
                }
                if (type == ElasticsearchDistribution.Type.DOCKER) continue;
                DistroTestPlugin.addDistro(distributions, architecture, type, null, ElasticsearchDistribution.Flavor.DEFAULT, true, upgradeVersion.toString(), upgradeDistros);
                if (!upgradeVersion.onOrAfter("6.3.0")) continue;
                DistroTestPlugin.addDistro(distributions, architecture, type, null, ElasticsearchDistribution.Flavor.OSS, true, upgradeVersion.toString(), upgradeDistros);
            }
        }
        for (Architecture architecture : Architecture.values()) {
            for (ElasticsearchDistribution.Platform platform : Arrays.asList(ElasticsearchDistribution.Platform.LINUX, ElasticsearchDistribution.Platform.WINDOWS)) {
                for (ElasticsearchDistribution.Flavor flavor : ElasticsearchDistribution.Flavor.values()) {
                    for (boolean bundledJdk : Arrays.asList(true, false)) {
                        if (!bundledJdk && architecture != Architecture.X64) continue;
                        DistroTestPlugin.addDistro(distributions, architecture, ElasticsearchDistribution.Type.ARCHIVE, platform, flavor, bundledJdk, VersionProperties.getElasticsearch(), currentDistros);
                    }
                }
            }
        }
        Configuration packagingConfig = (Configuration)project.getConfigurations().create(DISTRIBUTIONS_CONFIGURATION);
        List distroConfigs = currentDistros.stream().filter(d -> d.getType() != ElasticsearchDistribution.Type.DOCKER).map(ElasticsearchDistribution::getConfiguration).collect(Collectors.toList());
        packagingConfig.setExtendsFrom(distroConfigs);
        Configuration packagingUpgradeConfig = (Configuration)project.getConfigurations().create(UPGRADE_CONFIGURATION);
        List distroUpgradeConfigs = upgradeDistros.stream().map(ElasticsearchDistribution::getConfiguration).collect(Collectors.toList());
        packagingUpgradeConfig.setExtendsFrom(distroUpgradeConfigs);
        return currentDistros;
    }

    private static void addDistro(NamedDomainObjectContainer<ElasticsearchDistribution> distributions, Architecture architecture, ElasticsearchDistribution.Type type, ElasticsearchDistribution.Platform platform, ElasticsearchDistribution.Flavor flavor, boolean bundledJdk, String version, List<ElasticsearchDistribution> container) {
        String name = DistroTestPlugin.distroId(type, platform, flavor, bundledJdk, architecture) + "-" + version;
        if (distributions.findByName(name) != null) {
            return;
        }
        ElasticsearchDistribution distro = (ElasticsearchDistribution)distributions.create(name, d -> {
            d.setArchitecture(architecture);
            d.setFlavor(flavor);
            d.setType(type);
            if (type == ElasticsearchDistribution.Type.ARCHIVE) {
                d.setPlatform(platform);
            }
            if (type != ElasticsearchDistribution.Type.DOCKER) {
                d.setBundledJdk(bundledJdk);
            }
            d.setVersion(version);
        });
        if (type == ElasticsearchDistribution.Type.DOCKER) {
            distro.setFailIfUnavailable(false);
        }
        container.add(distro);
    }

    private static boolean isWindows(Project project) {
        return project.getName().contains("windows");
    }

    private static String distroId(ElasticsearchDistribution.Type type, ElasticsearchDistribution.Platform platform, ElasticsearchDistribution.Flavor flavor, boolean bundledJdk, Architecture architecture) {
        return flavor + "-" + (String)(type == ElasticsearchDistribution.Type.ARCHIVE ? platform + "-" : "") + type + (bundledJdk ? "" : "-no-jdk") + (String)(architecture == Architecture.X64 ? "" : "-" + architecture.toString().toLowerCase());
    }

    private static String destructiveDistroTestTaskName(ElasticsearchDistribution distro) {
        ElasticsearchDistribution.Type type = distro.getType();
        return "destructiveDistroTest." + DistroTestPlugin.distroId(type, distro.getPlatform(), distro.getFlavor(), distro.getBundledJdk(), distro.getArchitecture());
    }

    private static /* synthetic */ void lambda$configureCopyUpgradeTask$14(Path upgradePath, String upgradeFromVersion, Project project, Version upgradeVersion, Task action) {
        try {
            Files.write(upgradePath.resolve("version"), VersionProperties.getElasticsearch().getBytes(), new OpenOption[0]);
            Files.write(upgradePath.resolve("upgrade_from_version"), upgradeFromVersion.getBytes(), new OpenOption[0]);
            Path upgradeMarkerPath = upgradePath.resolve("upgrade_is_oss");
            project.delete(new Object[]{upgradeMarkerPath});
            if (upgradeVersion.onOrAfter("6.3.0")) {
                Files.write(upgradeMarkerPath, new byte[0], new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

