/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class BatsTestTask
extends DefaultTask {
    private final DirectoryProperty testsDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty utilsDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty distributionsDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty pluginsDir = this.getProject().getObjects().directoryProperty();
    private final DirectoryProperty upgradeDir = this.getProject().getObjects().directoryProperty();
    private String packageName;

    @InputDirectory
    public Provider<Directory> getTestsDir() {
        return this.testsDir;
    }

    public void setTestsDir(Directory testsDir) {
        this.testsDir.set((Object)testsDir);
    }

    @InputDirectory
    public Provider<Directory> getUtilsDir() {
        return this.utilsDir;
    }

    public void setUtilsDir(Directory utilsDir) {
        this.utilsDir.set((Object)utilsDir);
    }

    @InputDirectory
    public Provider<Directory> getDistributionsDir() {
        return this.distributionsDir;
    }

    public void setDistributionsDir(Provider<Directory> distributionsDir) {
        this.distributionsDir.set(distributionsDir);
    }

    @InputDirectory
    @Optional
    public Provider<Directory> getPluginsDir() {
        return this.pluginsDir;
    }

    public void setPluginsDir(Provider<Directory> pluginsDir) {
        this.pluginsDir.set(pluginsDir);
    }

    @InputDirectory
    @Optional
    public Provider<Directory> getUpgradeDir() {
        return this.upgradeDir;
    }

    public void setUpgradeDir(Provider<Directory> upgradeDir) {
        this.upgradeDir.set(upgradeDir);
    }

    @Input
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @TaskAction
    public void runBats() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("bats");
        command.add("--tap");
        command.addAll(this.testsDir.getAsFileTree().getFiles().stream().filter(f -> f.getName().endsWith(".bats")).sorted().collect(Collectors.toList()));
        this.getProject().exec(spec -> {
            spec.setWorkingDir((Object)this.distributionsDir.getAsFile());
            spec.environment(System.getenv());
            spec.environment("BATS_TESTS", (Object)((File)this.testsDir.getAsFile().get()).toString());
            spec.environment("BATS_UTILS", (Object)((File)this.utilsDir.getAsFile().get()).toString());
            if (this.pluginsDir.isPresent()) {
                spec.environment("BATS_PLUGINS", (Object)((File)this.pluginsDir.getAsFile().get()).toString());
            }
            if (this.upgradeDir.isPresent()) {
                spec.environment("BATS_UPGRADE", (Object)((File)this.upgradeDir.getAsFile().get()).toString());
            }
            spec.environment("PACKAGE_NAME", (Object)this.packageName);
            spec.setCommandLine((Iterable)command);
        });
    }
}

